/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.argument;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class LaunchCommand {
    private URL executableArkBizJar;
    private URL[] classpath;
    private String entryClassName;
    private String entryMethodName;
    private String[] launchArgs;
    private String[] profiles;

    public boolean isExecutedByCommandLine() {
        return this.executableArkBizJar != null;
    }

    public URL getExecutableArkBizJar() {
        return this.executableArkBizJar;
    }

    public LaunchCommand setExecutableArkBizJar(URL executableArkBizJar) {
        this.executableArkBizJar = executableArkBizJar;
        return this;
    }

    public URL[] getClasspath() {
        return this.classpath;
    }

    public LaunchCommand setClasspath(URL[] classpath) {
        this.classpath = classpath;
        return this;
    }

    public String getEntryMethodName() {
        return this.entryMethodName;
    }

    public LaunchCommand setEntryMethodName(String entryMethodName) {
        this.entryMethodName = entryMethodName;
        return this;
    }

    public String getEntryClassName() {
        return this.entryClassName;
    }

    public LaunchCommand setEntryClassName(String entryClassName) {
        this.entryClassName = entryClassName;
        return this;
    }

    public String[] getLaunchArgs() {
        return this.launchArgs;
    }

    public LaunchCommand setLaunchArgs(String[] launchArgs) {
        this.launchArgs = launchArgs;
        return this;
    }

    public String[] getProfiles() {
        String[] stringArray;
        if (this.profiles != null) {
            return this.profiles;
        }
        String profileVMArgs = System.getProperty("ark.profile");
        if (profileVMArgs == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = profileVMArgs.split(",");
        }
        return stringArray;
    }

    public LaunchCommand setProfiles(String[] profiles) {
        this.profiles = profiles;
        return this;
    }

    public static LaunchCommand parse(String[] args) throws MalformedURLException {
        LaunchCommand launchCommand = new LaunchCommand();
        String arkJarPrefix = String.format("%s%s=", "-A", "jar");
        String arkClasspathPrefix = String.format("%s%s=", "-A", "classpath");
        String entryClassNamePrefix = String.format("%s%s=", "-B", "className");
        String entryMethodNamePrefix = String.format("%s%s=", "-B", "methodName");
        String arkConfigProfilePrefix = String.format("%s%s=", "-A", "profile");
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            if ((arg = arg.trim()).startsWith(arkJarPrefix)) {
                String fatJarUrl = arg.substring(arkJarPrefix.length());
                launchCommand.setExecutableArkBizJar(new URL(fatJarUrl));
                continue;
            }
            if (arg.startsWith(entryClassNamePrefix)) {
                String entryClassName = arg.substring(entryClassNamePrefix.length());
                launchCommand.setEntryClassName(entryClassName);
                continue;
            }
            if (arg.startsWith(entryMethodNamePrefix)) {
                String entryMethodName = arg.substring(entryMethodNamePrefix.length());
                launchCommand.setEntryMethodName(entryMethodName);
                continue;
            }
            if (arg.startsWith(arkClasspathPrefix)) {
                String classpath = arg.substring(arkClasspathPrefix.length());
                ArrayList<URL> urlList = new ArrayList<URL>();
                for (String url : classpath.split(",")) {
                    if (url.isEmpty()) continue;
                    urlList.add(new URL(url));
                }
                launchCommand.setClasspath(urlList.toArray(new URL[urlList.size()]));
                continue;
            }
            if (arg.startsWith(arkConfigProfilePrefix)) {
                String profile = arg.substring(arkConfigProfilePrefix.length());
                launchCommand.setProfiles(profile.split(","));
                continue;
            }
            arguments.add(arg);
        }
        return launchCommand.setLaunchArgs(arguments.toArray(new String[0]));
    }

    public static String toString(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }
}

