/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BizOperation {
    private String bizName;
    private String bizVersion;
    private OperationType operationType;
    private Map<String, String> parameters = new HashMap<String, String>();

    public boolean isValid() {
        return this.operationType == OperationType.UNKNOWN;
    }

    public String getBizName() {
        return this.bizName;
    }

    public BizOperation setBizName(String bizName) {
        this.bizName = bizName;
        return this;
    }

    public String getBizVersion() {
        return this.bizVersion;
    }

    public BizOperation setBizVersion(String bizVersion) {
        this.bizVersion = bizVersion;
        return this;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public BizOperation setOperationType(OperationType operationType) {
        this.operationType = operationType;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public BizOperation setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public BizOperation putParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BizOperation)) {
            return false;
        }
        BizOperation that = (BizOperation)obj;
        if (!Objects.equals(this.getBizName(), that.getBizName())) {
            return false;
        }
        if (!Objects.equals(this.getBizVersion(), that.getBizVersion())) {
            return false;
        }
        return Objects.equals((Object)this.getOperationType(), (Object)that.getOperationType());
    }

    public static BizOperation createBizOperation() {
        return new BizOperation();
    }

    public static enum OperationType {
        INSTALL,
        UNINSTALL,
        SWITCH,
        CHECK,
        UNKNOWN;

    }
}

