/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.loader.LaunchedURLClassLoader;
import org.springframework.boot.loader.archive.Archive;

public class CachedLaunchedURLClassLoader
extends LaunchedURLClassLoader {
    private final Map<String, LoadClassResult> classCache = new ConcurrentHashMap<String, LoadClassResult>(3000);
    private final Map<String, Optional<URL>> resourceUrlCache = new ConcurrentHashMap<String, Optional<URL>>(3000);
    private final Map<String, Optional<Enumeration<URL>>> resourcesUrlCache = new ConcurrentHashMap<String, Optional<Enumeration<URL>>>(300);

    public CachedLaunchedURLClassLoader(boolean exploded, Archive rootArchive, URL[] urls, ClassLoader parent) {
        super(exploded, rootArchive, urls, parent);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClassWithCache(name, resolve);
    }

    public URL findResource(String name) {
        Optional<URL> urlOptional = this.resourceUrlCache.get(name);
        if (urlOptional != null) {
            return urlOptional.orElse(null);
        }
        URL url = super.findResource(name);
        this.resourceUrlCache.put(name, url != null ? Optional.of(url) : Optional.empty());
        return url;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Optional<Enumeration<URL>> urlOptional = this.resourcesUrlCache.get(name);
        if (urlOptional != null) {
            return urlOptional.orElse(null);
        }
        Enumeration enumeration = super.findResources(name);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            this.resourcesUrlCache.put(name, Optional.empty());
        }
        return enumeration;
    }

    protected Class<?> loadClassWithCache(String name, boolean resolve) throws ClassNotFoundException {
        LoadClassResult resultInCache = this.classCache.get(name);
        if (resultInCache != null) {
            if (resultInCache.getEx() != null) {
                throw resultInCache.getEx();
            }
            return resultInCache.getClazz();
        }
        try {
            Class clazz = super.findLoadedClass(name);
            if (clazz == null) {
                clazz = super.loadClass(name, resolve);
            }
            if (clazz == null) {
                this.classCache.put(name, LoadClassResult.NOT_FOUND);
            }
            return clazz;
        }
        catch (ClassNotFoundException exception) {
            this.classCache.put(name, LoadClassResult.NOT_FOUND);
            throw exception;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    protected static class LoadClassResult {
        private Class<?> clazz;
        private ClassNotFoundException ex;
        protected static LoadClassResult NOT_FOUND = new LoadClassResult(new ClassNotFoundException());

        public LoadClassResult() {
        }

        public LoadClassResult(ClassNotFoundException ex) {
            this.ex = ex;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public ClassNotFoundException getEx() {
            return this.ex;
        }

        public void setEx(ClassNotFoundException ex) {
            this.ex = ex;
        }
    }
}

