/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.web;

import com.alipay.sofa.ark.exception.ArkRuntimeException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class ArkCompositeReactorHttpHandlerAdapter
extends ReactorHttpHandlerAdapter {
    private Map<String, ReactorHttpHandlerAdapter> bizReactorHttpHandlerAdapters = new ConcurrentHashMap<String, ReactorHttpHandlerAdapter>();

    public ArkCompositeReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public Mono<Void> apply(HttpServerRequest reactorRequest, HttpServerResponse reactorResponse) {
        String uri = reactorRequest.uri();
        for (Map.Entry<String, ReactorHttpHandlerAdapter> entry : this.bizReactorHttpHandlerAdapters.entrySet()) {
            if (!uri.startsWith(entry.getKey())) continue;
            ReactorHttpHandlerAdapter adapter = entry.getValue();
            return adapter.apply(reactorRequest, reactorResponse);
        }
        return super.apply(reactorRequest, reactorResponse);
    }

    public void registerBizReactorHttpHandlerAdapter(String contextPath, ReactorHttpHandlerAdapter reactorHttpHandlerAdapter) {
        ReactorHttpHandlerAdapter old = this.bizReactorHttpHandlerAdapters.putIfAbsent(contextPath, reactorHttpHandlerAdapter);
        if (old != null) {
            throw new ArkRuntimeException("Duplicated context path");
        }
    }

    public void unregisterBizReactorHttpHandlerAdapter(String contextPath) {
        this.bizReactorHttpHandlerAdapters.remove(contextPath);
    }
}

