/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.web;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.web.EmbeddedServerService;
import com.alipay.sofa.ark.springboot.web.ArkCompositeReactorHttpHandlerAdapter;
import com.alipay.sofa.ark.springboot.web.ArkNettyWebServer;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.netty.NettyRouteProvider;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.client.reactive.ReactorResourceFactory;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpServer;
import reactor.netty.resources.LoopResources;

public class ArkNettyReactiveWebServerFactory
extends NettyReactiveWebServerFactory {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private Duration lifecycleTimeout;
    private List<NettyRouteProvider> routeProviders = new ArrayList<NettyRouteProvider>();
    @ArkInject
    private EmbeddedServerService embeddedNettyService;
    @ArkInject
    private BizManagerService bizManagerService;
    private boolean useForwardHeaders;
    private ReactorResourceFactory resourceFactory;
    private int backgroundProcessorDelay;
    private Set<NettyServerCustomizer> serverCustomizers = new LinkedHashSet<NettyServerCustomizer>();
    private static ArkCompositeReactorHttpHandlerAdapter adapter;

    public WebServer getWebServer(HttpHandler httpHandler) {
        if (this.embeddedNettyService == null && ArkClient.getInjectionService() != null) {
            ArkClient.getInjectionService().inject((Object)this);
        }
        if (this.embeddedNettyService == null) {
            return super.getWebServer(httpHandler);
        }
        if (this.embeddedNettyService.getEmbedServer(this.getPort()) == null) {
            this.embeddedNettyService.putEmbedServer(this.getPort(), (Object)this.initEmbedNetty());
        }
        String contextPath = this.getContextPath();
        HashMap<String, HttpHandler> handlerMap = new HashMap<String, HttpHandler>();
        handlerMap.put(contextPath, httpHandler);
        ContextPathCompositeHandler contextHandler = new ContextPathCompositeHandler(handlerMap);
        if (adapter == null) {
            adapter = new ArkCompositeReactorHttpHandlerAdapter((HttpHandler)contextHandler);
        } else {
            adapter.registerBizReactorHttpHandlerAdapter(contextPath, new ReactorHttpHandlerAdapter((HttpHandler)contextHandler));
        }
        HttpServer httpServer = (HttpServer)this.embeddedNettyService.getEmbedServer(this.getPort());
        ArkNettyWebServer webServer = (ArkNettyWebServer)this.createNettyWebServer(contextPath, httpServer, adapter, this.lifecycleTimeout);
        webServer.setRouteProviders(this.routeProviders);
        return webServer;
    }

    public String getContextPath() {
        String contextPath = "";
        if (this.bizManagerService == null) {
            return contextPath;
        }
        Biz biz = this.bizManagerService.getBizByClassLoader(Thread.currentThread().getContextClassLoader());
        if (!StringUtils.isEmpty((Object)contextPath)) {
            return contextPath;
        }
        if (biz != null) {
            if (StringUtils.isEmpty((Object)biz.getWebContextPath())) {
                return "/";
            }
            contextPath = biz.getWebContextPath();
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            return contextPath;
        }
        return "/";
    }

    WebServer createNettyWebServer(String contextPath, HttpServer httpServer, ReactorHttpHandlerAdapter handlerAdapter, Duration lifecycleTimeout) {
        return new ArkNettyWebServer(contextPath, httpServer, handlerAdapter, lifecycleTimeout);
    }

    private HttpServer initEmbedNetty() {
        HttpServer server = HttpServer.create();
        if (this.resourceFactory != null) {
            LoopResources resources = this.resourceFactory.getLoopResources();
            Assert.notNull((Object)resources, (String)"No LoopResources: is ReactorResourceFactory not initialized yet?");
            server = server.tcpConfiguration(tcpServer -> tcpServer.runOn(resources)).bindAddress(this::getListenAddress);
        } else {
            server = server.bindAddress(this::getListenAddress);
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            server = this.customizeSslConfiguration(server);
        }
        server = server.protocol(this.listProtocols()).forwarded(this.useForwardHeaders);
        return this.applyCustomizers(server);
    }

    private HttpServer customizeSslConfiguration(HttpServer httpServer) {
        SslServerCustomizer sslServerCustomizer = new SslServerCustomizer(this.getSsl(), this.getHttp2(), this.getSslStoreProvider());
        return sslServerCustomizer.apply(httpServer);
    }

    private HttpProtocol[] listProtocols() {
        ArrayList<HttpProtocol> protocols = new ArrayList<HttpProtocol>();
        protocols.add(HttpProtocol.HTTP11);
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            if (this.getSsl() != null && this.getSsl().isEnabled()) {
                protocols.add(HttpProtocol.H2);
            } else {
                protocols.add(HttpProtocol.H2C);
            }
        }
        return protocols.toArray(new HttpProtocol[0]);
    }

    private HttpServer applyCustomizers(HttpServer server) {
        for (NettyServerCustomizer customizer : this.serverCustomizers) {
            server = (HttpServer)customizer.apply((Object)server);
        }
        return server;
    }

    private InetSocketAddress getListenAddress() {
        return this.getAddress() != null ? new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
    }
}

