/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.springboot.web;

import com.alipay.sofa.ark.api.ArkClient;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.ark.spi.web.EmbeddedServerService;
import com.alipay.sofa.ark.springboot.web.ArkTomcatWebServer;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ArkTomcatServletWebServerFactory
extends TomcatServletWebServerFactory {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Object lock = new Object();
    @ArkInject
    private EmbeddedServerService embeddedServerService;
    @ArkInject
    private BizManagerService bizManagerService;
    private File baseDirectory;
    private String protocol = "org.apache.coyote.http11.Http11NioProtocol";
    private int backgroundProcessorDelay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        if (this.embeddedServerService == null && ArkClient.getInjectionService() != null) {
            ArkClient.getInjectionService().inject((Object)this);
        }
        if (this.embeddedServerService == null) {
            return super.getWebServer(initializers);
        }
        if (this.embeddedServerService.getEmbedServer(this.getPort()) == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.embeddedServerService.getEmbedServer(this.getPort()) == null) {
                    this.embeddedServerService.putEmbedServer(this.getPort(), (Object)this.initEmbedTomcat());
                }
            }
        }
        Tomcat embedTomcat = (Tomcat)this.embeddedServerService.getEmbedServer(this.getPort());
        this.prepareContext(embedTomcat.getHost(), initializers);
        return this.getWebServer(embedTomcat);
    }

    public String getContextPath() {
        String contextPath = super.getContextPath();
        if (this.bizManagerService == null) {
            return contextPath;
        }
        Biz biz = this.bizManagerService.getBizByClassLoader(Thread.currentThread().getContextClassLoader());
        if (!StringUtils.isEmpty((Object)contextPath)) {
            return contextPath;
        }
        if (biz != null) {
            if (StringUtils.isEmpty((Object)biz.getWebContextPath())) {
                return "/";
            }
            return biz.getWebContextPath();
        }
        return "/";
    }

    private Tomcat initEmbedTomcat() {
        Tomcat tomcat = new Tomcat();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tomcat");
        tomcat.setBaseDir(baseDir.getAbsolutePath());
        Connector connector = new Connector(this.protocol);
        tomcat.getService().addConnector(connector);
        this.customizeConnector(connector);
        tomcat.setConnector(connector);
        tomcat.getHost().setAutoDeploy(false);
        this.configureEngine(tomcat.getEngine());
        for (Connector additionalConnector : this.getAdditionalTomcatConnectors()) {
            tomcat.getService().addConnector(additionalConnector);
        }
        return tomcat;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setProtocol(String protocol) {
        AssertUtils.isFalse((boolean)StringUtils.isEmpty((Object)protocol), (String)"Protocol must not be empty", (Object[])new Object[0]);
        this.protocol = protocol;
    }

    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.getEngineValves()) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void postProcessContext(Context context) {
        ((WebappLoader)context.getLoader()).setLoaderClass("com.alipay.sofa.ark.web.embed.tomcat.ArkTomcatEmbeddedWebappClassLoader");
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        if (host.getState() == LifecycleState.NEW) {
            super.prepareContext(host, initializers);
        } else {
            File documentRoot = this.getValidDocumentRoot();
            StandardContext context = new StandardContext();
            if (documentRoot != null) {
                context.setResources((WebResourceRoot)new StandardRoot((Context)context));
            }
            context.setName(this.getContextPath());
            context.setDisplayName(this.getDisplayName());
            context.setPath(this.getContextPath());
            File docBase = documentRoot != null ? documentRoot : this.createTempDir("tomcat-docbase");
            context.setDocBase(docBase.getAbsolutePath());
            context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
            context.setParentClassLoader(Thread.currentThread().getContextClassLoader());
            this.resetDefaultLocaleMapping(context);
            this.addLocaleMappings(context);
            context.setUseRelativeRedirects(false);
            this.configureTldSkipPatterns(context);
            WebappLoader loader = new WebappLoader();
            loader.setLoaderClass("com.alipay.sofa.ark.web.embed.tomcat.ArkTomcatEmbeddedWebappClassLoader");
            loader.setDelegate(true);
            context.setLoader((Loader)loader);
            if (this.isRegisterDefaultServlet()) {
                this.addDefaultServlet((Context)context);
            }
            if (this.shouldRegisterJspServlet()) {
                this.addJspServlet((Context)context);
                this.addJasperInitializer(context);
            }
            context.addLifecycleListener((LifecycleListener)new StaticResourceConfigurer((Context)context));
            ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
            context.setParent((Container)host);
            this.configureContext((Context)context, initializersToUse);
            host.addChild((Container)context);
        }
    }

    private void resetDefaultLocaleMapping(StandardContext context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(StandardContext context) {
        for (Map.Entry entry : this.getLocaleCharsetMappings().entrySet()) {
            context.addLocaleEncodingMappingParameter(((Locale)entry.getKey()).toString(), ((Charset)entry.getValue()).toString());
        }
    }

    private void configureTldSkipPatterns(StandardContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString((Collection)this.getTldSkipPatterns()));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("org.apache.catalina.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        for (Map.Entry entry : this.getJsp().getInitParameters().entrySet()) {
            jspServlet.addInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(StandardContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"org.apache.jasper.servlet.JasperInitializer", null).newInstance();
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected WebServer getWebServer(Tomcat tomcat) {
        return new ArkTomcatWebServer(tomcat, this.getPort() >= 0, tomcat);
    }

    final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.addResourceJars(ArkTomcatServletWebServerFactory.this.getUrlsOfJarsWithMetaInfResources());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String path = url.getPath();
                if (path.endsWith(".jar") || path.endsWith(".jar!/")) {
                    String jar = url.toString();
                    if (!jar.startsWith("jar:")) {
                        jar = "jar:" + jar + "!/";
                    }
                    this.addResourceSet(jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }
}

