/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.support.startup;

import com.alipay.sofa.ark.bootstrap.ClasspathLauncher;
import com.alipay.sofa.ark.common.util.AssertUtils;
import com.alipay.sofa.ark.common.util.ClassLoaderUtils;
import com.alipay.sofa.ark.support.startup.EntryMethod;
import com.alipay.sofa.ark.support.thread.IsolatedThreadGroup;
import com.alipay.sofa.ark.support.thread.LaunchRunner;
import java.net.URL;

public class SofaArkBootstrap {
    private static final String BIZ_CLASSLOADER = "com.alipay.sofa.ark.container.service.classloader.BizClassLoader";
    private static final String MAIN_ENTRY_NAME = "remain";
    private static EntryMethod entryMethod;

    public static void launch(String[] args) {
        try {
            if (!SofaArkBootstrap.isSofaArkStarted()) {
                entryMethod = new EntryMethod(Thread.currentThread());
                IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(entryMethod.getDeclaringClassName());
                LaunchRunner launchRunner = new LaunchRunner(SofaArkBootstrap.class.getName(), MAIN_ENTRY_NAME, args);
                Thread launchThread = new Thread(threadGroup, launchRunner, entryMethod.getMethodName());
                launchThread.start();
                LaunchRunner.join(threadGroup);
                threadGroup.rethrowUncaughtException();
                System.exit(0);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Object prepareContainerForTest(Class testClass) {
        try {
            URL[] urls = SofaArkBootstrap.getURLClassPath();
            return new ClasspathLauncher(new ClasspathLauncher.ClassPathArchive(testClass.getCanonicalName(), null, urls)).launch(SofaArkBootstrap.getClasspath(urls), testClass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void remain(String[] args) throws Exception {
        AssertUtils.assertNotNull((Object)entryMethod, (String)"No Entry Method Found.");
        URL[] urls = SofaArkBootstrap.getURLClassPath();
        new ClasspathLauncher(new ClasspathLauncher.ClassPathArchive(entryMethod.getDeclaringClassName(), entryMethod.getMethodName(), urls)).launch(args, SofaArkBootstrap.getClasspath(urls), entryMethod.getMethod());
    }

    private static String getClasspath(URL[] urls) {
        StringBuilder sb = new StringBuilder();
        for (URL url : urls) {
            sb.append(url.toExternalForm()).append(",");
        }
        return sb.toString();
    }

    private static URL[] getURLClassPath() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        return ClassLoaderUtils.getURLs((ClassLoader)classLoader);
    }

    private static boolean isSofaArkStarted() {
        Class<?> bizClassLoader = SofaArkBootstrap.class.getClassLoader().getClass();
        return BIZ_CLASSLOADER.equals(bizClassLoader.getCanonicalName());
    }
}

