/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class IndexLine {
    private List<String> token = new ArrayList<String>();
    private boolean caseSensitive;
    private List<String> includeKeys = new ArrayList<String>();
    private List<String> excludeKeys = new ArrayList<String>();

    public IndexLine() {
    }

    public IndexLine(List<String> token, boolean caseSensitive) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
    }

    public IndexLine(IndexLine other) {
        this.SetToken(other.GetToken());
        this.caseSensitive = other.GetCaseSensitive();
        this.SetIncludeKeys(other.GetIncludeKeys());
        this.SetExcludeKeys(other.GetExcludeKeys());
    }

    public List<String> GetToken() {
        return this.token;
    }

    public boolean GetCaseSensitive() {
        return this.caseSensitive;
    }

    public void SetToken(List<String> token) {
        this.token = new ArrayList<String>(token);
    }

    public void SetCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public List<String> GetIncludeKeys() {
        return this.includeKeys;
    }

    public List<String> GetExcludeKeys() {
        return this.excludeKeys;
    }

    public void SetIncludeKeys(List<String> includeKeys) {
        this.includeKeys = new ArrayList<String>(includeKeys);
    }

    public void SetExcludeKeys(List<String> excludeKeys) {
        this.excludeKeys = new ArrayList<String>(excludeKeys);
    }

    public JSONObject ToRequestJson() {
        JSONObject line = new JSONObject();
        JSONArray tokenDict = new JSONArray();
        for (String v : this.token) {
            tokenDict.add((Object)v);
        }
        line.put((Object)"token", (Object)tokenDict);
        if (this.includeKeys.size() > 0) {
            JSONArray includeKeysDict = new JSONArray();
            for (String v : this.includeKeys) {
                includeKeysDict.add((Object)v);
            }
            line.put((Object)"include_keys", (Object)includeKeysDict);
        }
        if (this.excludeKeys.size() > 0) {
            JSONArray excludeKeysDict = new JSONArray();
            for (String v : this.excludeKeys) {
                excludeKeysDict.add((Object)v);
            }
            line.put((Object)"exclude_keys", (Object)excludeKeysDict);
        }
        line.put((Object)"caseSensitive", (Object)this.GetCaseSensitive());
        return line;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject line = this.ToRequestJson();
        return line;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            int i;
            this.SetCaseSensitive(dict.getBoolean("caseSensitive"));
            JSONArray tokenDict = dict.getJSONArray("token");
            this.token = new ArrayList<String>();
            for (int i2 = 0; i2 < tokenDict.size(); ++i2) {
                this.token.add(tokenDict.getString(i2));
            }
            if (dict.containsKey((Object)"include_keys")) {
                JSONArray includeKeysDict = dict.getJSONArray("include_keys");
                this.includeKeys = new ArrayList<String>();
                for (i = 0; i < includeKeysDict.size(); ++i) {
                    this.includeKeys.add(includeKeysDict.getString(i));
                }
            }
            if (dict.containsKey((Object)"exclude_keys")) {
                JSONArray excludeKeysDict = dict.getJSONArray("exclude_keys");
                this.excludeKeys = new ArrayList<String>();
                for (i = 0; i < excludeKeysDict.size(); ++i) {
                    this.excludeKeys.add(excludeKeysDict.getString(i));
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexLine", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexLineString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)indexLineString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexLine", e.getMessage(), e, "");
        }
    }
}

