/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.ons.api.impl.authority.AuthUtil;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import java.lang.reflect.Field;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ClientRPCHook
implements RPCHook {
    private SessionCredentials sessionCredentials;
    private ConcurrentHashMap<Class<? extends CommandCustomHeader>, Field[]> fieldCache;

    public ClientRPCHook(SessionCredentials sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
        this.fieldCache = new ConcurrentHashMap();
    }

    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
        CommandCustomHeader header = request.readCustomHeader();
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("AccessKey", this.sessionCredentials.getAccessKey());
        map.put("OnsChannel", this.sessionCredentials.getOnsChannel().toString());
        try {
            if (null != header) {
                Field[] fields = this.fieldCache.get(header.getClass());
                if (null == fields) {
                    for (Field field : fields = header.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                    }
                    Field[] tmp = this.fieldCache.putIfAbsent(header.getClass(), fields);
                    if (null != tmp) {
                        fields = tmp;
                    }
                }
                for (Field field : fields) {
                    Object value = field.get(header);
                    if (null == value) continue;
                    map.put(field.getName(), value.toString());
                }
            }
            byte[] total = AuthUtil.combineRequestContent(request, map);
            String signature = AuthUtil.calSignature(total, this.sessionCredentials.getSecretKey());
            request.addExtField("Signature", signature);
            request.addExtField("AccessKey", this.sessionCredentials.getAccessKey());
            request.addExtField("OnsChannel", this.sessionCredentials.getOnsChannel().toString());
        }
        catch (Exception e) {
            throw new RuntimeException("incompatible exception.", e);
        }
    }

    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
    }
}

