/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceConstants;
import com.alibaba.ons.open.trace.core.dispatch.AsyncAppender;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceAppender;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncTraceDispatcher;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.alibaba.rocketmq.common.message.MessageAccessor;
import com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class TransactionProducerImpl
extends ONSClientAbstract
implements TransactionProducer {
    private static final Logger log = ClientLogger.getLog();
    private final AtomicBoolean started = new AtomicBoolean(false);
    TransactionMQProducer transactionMQProducer = null;
    private Properties properties;
    private AsyncDispatcher traceDispatcher = null;

    public TransactionProducerImpl(Properties properties, TransactionCheckListener transactionCheckListener) {
        super(properties);
        this.properties = properties;
        this.transactionMQProducer = new TransactionMQProducer((String)properties.get("ProducerId"), (RPCHook)new ClientRPCHook(this.sessionCredentials));
        boolean isVipChannelEnabled = Boolean.parseBoolean(properties.getProperty("isVipChannelEnabled", "false"));
        this.transactionMQProducer.setVipChannelEnabled(isVipChannelEnabled);
        this.transactionMQProducer.setTransactionCheckListener(transactionCheckListener);
        try {
            Properties tempProperties = new Properties();
            tempProperties.put("AccessKey", this.sessionCredentials.getAccessKey());
            tempProperties.put("SecretKey", this.sessionCredentials.getSecretKey());
            tempProperties.put("MaxMsgSize", "128000");
            tempProperties.put("AsyncBufferSize", "2048");
            tempProperties.put("MaxBatchNum", "1");
            tempProperties.put("WakeUpNum", "1");
            tempProperties.put(OnsTraceConstants.NAMESRV_ADDR, this.getNameServerAddr());
            tempProperties.put("InstanceName", this.buildIntanceName());
            AsyncTraceAppender appender = new AsyncTraceAppender(tempProperties);
            this.traceDispatcher = new AsyncTraceDispatcher(tempProperties);
            this.traceDispatcher.start((AsyncAppender)appender, this.transactionMQProducer.getInstanceName());
            this.transactionMQProducer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new OnsClientSendMessageHookImpl(this.traceDispatcher));
        }
        catch (Throwable e) {
            log.error("system mqtrace hook init failed ,maybe can't send msg trace data");
        }
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.transactionMQProducer.getTransactionCheckListener() == null) {
                throw new IllegalArgumentException("TransactionCheckListener is null");
            }
            this.transactionMQProducer.setNamesrvAddr(this.nameServerAddr);
            try {
                this.transactionMQProducer.start();
            }
            catch (MQClientException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            if (this.traceDispatcher != null) {
                try {
                    this.traceDispatcher.flush();
                }
                catch (IOException e) {
                    log.error("system mqtrace hook shutdown failed ,maybe loss some trace data");
                }
            }
            this.transactionMQProducer.shutdown();
        }
    }

    public SendResult send(final Message message, final com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter executer, Object arg) {
        this.checkONSProducerServiceState(this.transactionMQProducer.getDefaultMQProducerImpl());
        com.alibaba.rocketmq.common.message.Message msgRMQ = ONSUtil.msgConvert(message);
        MessageAccessor.putProperty((com.alibaba.rocketmq.common.message.Message)msgRMQ, (String)"ProducerId", (String)((String)this.properties.get("ProducerId")));
        TransactionSendResult sendResultRMQ = null;
        try {
            sendResultRMQ = this.transactionMQProducer.sendMessageInTransaction(msgRMQ, new LocalTransactionExecuter(){

                public LocalTransactionState executeLocalTransactionBranch(com.alibaba.rocketmq.common.message.Message msg, Object arg) {
                    String msgId = msg.getProperty("__transactionId__");
                    message.setMsgID(msgId);
                    TransactionStatus transactionStatus = executer.execute(message, arg);
                    if (TransactionStatus.CommitTransaction == transactionStatus) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    }
                    if (TransactionStatus.RollbackTransaction == transactionStatus) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (sendResultRMQ.getLocalTransactionState() == LocalTransactionState.ROLLBACK_MESSAGE) {
            throw new RuntimeException("local transaction branch failed ,so transaction rollback");
        }
        SendResult sendResult = new SendResult();
        sendResult.setMessageId(sendResultRMQ.getMsgId());
        return sendResult;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }
}

