/*
 * Copyright (C) 2011 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Arithmetic functions operating on primitive values and {@link java.math.BigInteger} instances.
 *
 * <p>This package is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 * 
 * <p>See the Guava User Guide article on <a href=
 * "https://github.com.aliyun.openservices.shade.com.google/guava/wiki/MathExplained">
 * math utilities</a>.
 */
@ParametersAreNonnullByDefault
package com.aliyun.openservices.shade.com.google.common.math;

import javax.annotation.ParametersAreNonnullByDefault;

