/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.auth.ServiceCredentials;
import com.aliyun.openservices.ots.auth.ServiceSignature;
import com.aliyun.openservices.ots.comm.ResponseHandler;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.utils.CodingUtils;
import com.aliyun.openservices.ots.utils.DateUtil;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class OTSValidationResponseHandler
implements ResponseHandler {
    private int responseExpireMinutes = 15;
    private ServiceCredentials credentials;
    private String otsAction;

    public OTSValidationResponseHandler(ServiceCredentials credentials, String otsAction) {
        CodingUtils.assertParameterNotNull(credentials, "credentials");
        CodingUtils.assertParameterNotNull(otsAction, "otsAction");
        this.credentials = credentials;
        this.otsAction = otsAction;
    }

    public int getResponseExpireMinutes() {
        return this.responseExpireMinutes;
    }

    public void setResponseExpireMinutes(int responseExpireMinutes) {
        this.responseExpireMinutes = responseExpireMinutes;
    }

    @Override
    public void handle(ResponseMessage responseData) throws ClientException {
        Date responseDate;
        Map<String, String> headers = responseData.getHeadersMap();
        if (!headers.containsKey("x-ots-date")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-date"), null);
        }
        if (!headers.containsKey("x-ots-contentmd5")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-contentmd5"), null);
        }
        if (!headers.containsKey("x-ots-contenttype")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "x-ots-contenttype"), null);
        }
        if (!headers.containsKey("Authorization")) {
            throw OTSExceptionFactory.createResponseException(OTSUtil.OTS_RESOURCE_MANAGER.getFormattedString("MissingHeader", "Authorization"), null);
        }
        String NEW_LINE = "\n";
        try {
            responseDate = DateUtil.parseRfc822Date(headers.get("x-ots-date"));
        }
        catch (IllegalArgumentException e) {
            throw OTSExceptionFactory.createResponseException("Parse date header from response failed.", e);
        }
        catch (UnsupportedOperationException e) {
            throw OTSExceptionFactory.createResponseException("Parse date header from response failed.", e);
        }
        Date now = new Date();
        long span = (now.getTime() - responseDate.getTime()) / 60000L;
        if (span > (long)this.responseExpireMinutes) {
            throw OTSExceptionFactory.createResponseException("The response has expired.", null);
        }
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        sortedMap.putAll(headers);
        for (String key : sortedMap.keySet()) {
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key);
            canonicalizedOtsHeader.append(":");
            canonicalizedOtsHeader.append((String)sortedMap.get(key));
            canonicalizedOtsHeader.append("\n");
        }
        String canonicalizedResource = "/" + this.otsAction;
        String data = canonicalizedOtsHeader.toString() + canonicalizedResource;
        String actualSign = ServiceSignature.create().computeSignature(this.credentials.getAccessKeySecret(), data);
        String authHeader = headers.get("Authorization");
        boolean authEqual = false;
        if (authHeader.contains(":")) {
            String[] arr = authHeader.split(":");
            authEqual = arr[arr.length - 1].endsWith(actualSign);
        }
        if (!authEqual) {
            throw OTSExceptionFactory.createResponseException("\u8fd4\u56de\u7ed3\u679c\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002", null);
        }
    }
}

