/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.log;

import com.aliyun.openservices.ots.internal.OTSExecutionContext;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtil {
    public static Logger LOG = LoggerFactory.getLogger(OTSOperation.class);

    public static void logBeforeExecution(OTSExecutionContext executionContext) {
        OTSTraceLogger traceLogger = executionContext.getTraceLogger();
        int retries = executionContext.getRetries();
        if (retries == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "FirstExecution");
            }
            traceLogger.addEventTime("FirstExecution", System.currentTimeMillis());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "StartRetry" + retries);
            }
            traceLogger.addEventTime("StartRetry", System.currentTimeMillis());
        }
    }

    public static void logRequestInfo(OTSTraceLogger traceLogger, String otsAction, int contentSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "OTSAction:" + otsAction + "\t" + "RequestContentSize:" + contentSize);
        }
        traceLogger.addRequestInfo("OTSAction", otsAction);
        traceLogger.addRequestInfo("RequestContentSize", "" + contentSize);
    }

    public static void logOnCompleted(OTSExecutionContext executionContext, String requestId) {
        OTSTraceLogger traceLogger = executionContext.getTraceLogger();
        int retries = executionContext.getRetries();
        if (LOG.isDebugEnabled()) {
            LOG.debug("TraceId:" + traceLogger.getTraceId() + "\t" + "Completed" + "\t" + "Retries:" + retries + "\t" + "RequestId:" + requestId);
        }
        traceLogger.addEventTime("Completed", System.currentTimeMillis());
        if (requestId != null) {
            traceLogger.addRequestInfo("RequestId", requestId);
        }
    }

    public static void logOnFailed(OTSExecutionContext executionContext, Exception ex, String requestId) {
        OTSTraceLogger traceLogger = executionContext.getTraceLogger();
        int retries = executionContext.getRetries();
        if (LOG.isErrorEnabled()) {
            LOG.error("TraceId:" + traceLogger.getTraceId() + "\t" + "Failed" + "\t" + "Retries:" + retries + "\t" + ex);
        }
        traceLogger.addEventTime("Failed", System.currentTimeMillis());
        if (requestId != null) {
            traceLogger.addRequestInfo("RequestId", requestId);
        }
    }
}

