/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.ConsumedCapacity;
import com.aliyun.openservices.ots.model.Error;
import com.aliyun.openservices.ots.model.OTSResult;
import com.aliyun.openservices.ots.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchGetRowResult
extends OTSResult {
    private Map<String, List<RowStatus>> tableToRowsStatus = new HashMap<String, List<RowStatus>>();

    public BatchGetRowResult(OTSResult meta) {
        super(meta);
    }

    public void addResult(RowStatus status) {
        String tableName = status.getTableName();
        List<RowStatus> tableRowStatus = this.tableToRowsStatus.get(tableName);
        if (tableRowStatus == null) {
            tableRowStatus = new ArrayList<RowStatus>();
            this.tableToRowsStatus.put(tableName, tableRowStatus);
        }
        tableRowStatus.add(status);
    }

    public List<RowStatus> getBatchGetRowStatus(String tableName) {
        return this.tableToRowsStatus.get(tableName);
    }

    public Map<String, List<RowStatus>> getTableToRowsStatus() {
        return this.tableToRowsStatus;
    }

    public List<RowStatus> getFailedRows() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResult(null, result);
        return result;
    }

    public List<RowStatus> getSucceedRows() {
        ArrayList<RowStatus> result = new ArrayList<RowStatus>();
        this.getResult(result, null);
        return result;
    }

    public void getResult(List<RowStatus> succeedRows, List<RowStatus> failedRows) {
        for (Map.Entry<String, List<RowStatus>> entry : this.tableToRowsStatus.entrySet()) {
            for (RowStatus rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public boolean isAllSucceed() {
        return this.getFailedRows().isEmpty();
    }

    public static class RowStatus {
        private boolean isSucceed = false;
        private String tableName;
        private Error error;
        private Row row;
        private ConsumedCapacity consumedCapacity;
        private int index;

        public RowStatus(String tableName, Error error, int index) {
            this.isSucceed = false;
            this.tableName = tableName;
            this.error = error;
            this.index = index;
        }

        public RowStatus(String tableName, Row row, ConsumedCapacity consumedCapacity, int index) {
            this.isSucceed = true;
            this.tableName = tableName;
            this.row = row;
            this.consumedCapacity = consumedCapacity;
            this.index = index;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Error getError() {
            return this.error;
        }

        public Row getRow() {
            return this.row;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

