/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model;

import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.Error;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchWriteRowResponse
extends Response {
    private Map<String, List<RowResult>> tableToRowStatus = new HashMap<String, List<RowResult>>();

    public BatchWriteRowResponse(Response meta) {
        super(meta);
    }

    public void addRowResult(RowResult status) {
        String tableName = status.getTableName();
        List<RowResult> statuses = this.tableToRowStatus.get(tableName);
        if (statuses == null) {
            statuses = new ArrayList<RowResult>();
            this.tableToRowStatus.put(tableName, statuses);
        }
        statuses.add(status);
    }

    public List<RowResult> getRowStatus(String tableName) {
        return this.tableToRowStatus.get(tableName);
    }

    public Map<String, List<RowResult>> getRowStatus() {
        return this.tableToRowStatus;
    }

    public List<RowResult> getFailedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(null, result);
        return result;
    }

    public List<RowResult> getSucceedRows() {
        ArrayList<RowResult> result = new ArrayList<RowResult>();
        this.getResult(result, null);
        return result;
    }

    public void getResult(List<RowResult> succeedRows, List<RowResult> failedRows) {
        for (Map.Entry<String, List<RowResult>> entry : this.tableToRowStatus.entrySet()) {
            for (RowResult rs : entry.getValue()) {
                if (rs.isSucceed) {
                    if (succeedRows == null) continue;
                    succeedRows.add(rs);
                    continue;
                }
                if (failedRows == null) continue;
                failedRows.add(rs);
            }
        }
    }

    public boolean isAllSucceed() {
        return this.getFailedRows().isEmpty();
    }

    public static class RowResult {
        private boolean isSucceed = false;
        private String tableName;
        private Error error;
        private ConsumedCapacity consumedCapacity;
        private int index;
        private Row row;

        public RowResult(String tableName, Row row, Error error, int index) {
            this.tableName = tableName;
            this.isSucceed = false;
            this.error = error;
            this.index = index;
            this.row = row;
        }

        public RowResult(String tableName, Row row, ConsumedCapacity consumedCapacity, int index) {
            this.tableName = tableName;
            this.isSucceed = true;
            this.consumedCapacity = consumedCapacity;
            this.index = index;
            this.row = row;
        }

        public boolean isSucceed() {
            return this.isSucceed;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Error getError() {
            return this.error;
        }

        public ConsumedCapacity getConsumedCapacity() {
            return this.consumedCapacity;
        }

        public int getIndex() {
            return this.index;
        }

        public Row getRow() {
            return this.row;
        }
    }
}

