/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.core;

import com.alicloud.openservices.tablestore.AsyncClientInterface;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.ReturnType;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.SearchResponse;
import com.alicloud.openservices.tablestore.model.search.query.BoolQuery;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.TermQuery;
import com.alicloud.openservices.tablestore.timeline.TimelineCallback;
import com.alicloud.openservices.tablestore.timeline.TimelineException;
import com.alicloud.openservices.tablestore.timeline.TimelineQueue;
import com.alicloud.openservices.tablestore.timeline.core.TimelineEntryIterator;
import com.alicloud.openservices.tablestore.timeline.model.RowPutChangeWithCallback;
import com.alicloud.openservices.tablestore.timeline.model.TimelineEntry;
import com.alicloud.openservices.tablestore.timeline.model.TimelineIdentifier;
import com.alicloud.openservices.tablestore.timeline.model.TimelineMessage;
import com.alicloud.openservices.tablestore.timeline.model.TimelineSchema;
import com.alicloud.openservices.tablestore.timeline.query.ScanParameter;
import com.alicloud.openservices.tablestore.timeline.query.SearchParameter;
import com.alicloud.openservices.tablestore.timeline.query.SearchResult;
import com.alicloud.openservices.tablestore.timeline.utils.Preconditions;
import com.alicloud.openservices.tablestore.timeline.utils.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimelineQueueImpl
implements TimelineQueue {
    private SyncClientInterface client;
    private AsyncClientInterface asyncClient;
    private TimelineSchema schema;
    private TimelineIdentifier identifier;
    private TableStoreWriter writer;

    public TimelineQueueImpl(SyncClientInterface client, TableStoreWriter writer, TimelineSchema schema, TimelineIdentifier identifier) {
        this.client = client;
        this.writer = writer;
        this.asyncClient = client.asAsyncClient();
        this.schema = schema;
        this.identifier = identifier;
    }

    @Override
    public TimelineIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    public TimelineEntry store(TimelineMessage message) {
        long sequenceId;
        Preconditions.checkArgument(this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not auto generated.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), -1L, this.schema.isAutoGenerateSeqId());
        RowPutChange rowChange = new RowPutChange(this.schema.getTableName(), primaryKey);
        PutRowRequest request = new PutRowRequest();
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.addColumn(column);
        }
        rowChange.setReturnType(ReturnType.RT_PK);
        request.setRowChange(rowChange);
        try {
            PutRowResponse response = this.client.putRow(request);
            sequenceId = response.getRow().getPrimaryKey().getPrimaryKeyColumn(this.schema.getSequenceIdColumnName()).getValue().asLong();
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return new TimelineEntry(sequenceId, message);
    }

    @Override
    public TimelineEntry store(long sequenceId, TimelineMessage message) {
        Preconditions.checkArgument(!this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not auto generated.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, this.schema.isAutoGenerateSeqId());
        RowPutChange rowChange = new RowPutChange(this.schema.getTableName(), primaryKey);
        PutRowRequest request = new PutRowRequest();
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.addColumn(column);
        }
        request.setRowChange(rowChange);
        try {
            this.client.putRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return new TimelineEntry(sequenceId, message);
    }

    @Override
    public Future<TimelineEntry> storeAsync(TimelineMessage message, TimelineCallback callback) {
        Preconditions.checkArgument(this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not auto generated.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), -1L, this.schema.isAutoGenerateSeqId());
        RowPutChange rowChange = new RowPutChange(this.schema.getTableName(), primaryKey);
        PutRowRequest request = new PutRowRequest();
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.addColumn(column);
        }
        rowChange.setReturnType(ReturnType.RT_PK);
        request.setRowChange(rowChange);
        return this.doStoreAsync(-1L, message, request, callback);
    }

    @Override
    public Future<TimelineEntry> storeAsync(long sequenceId, TimelineMessage message, TimelineCallback callback) {
        Preconditions.checkArgument(!this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not allowed to set manually.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, this.schema.isAutoGenerateSeqId());
        RowPutChange rowChange = new RowPutChange(this.schema.getTableName(), primaryKey);
        PutRowRequest request = new PutRowRequest();
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.addColumn(column);
        }
        rowChange.setReturnType(ReturnType.RT_PK);
        request.setRowChange(rowChange);
        return this.doStoreAsync(sequenceId, message, request, callback);
    }

    @Override
    public Future<TimelineEntry> batchStore(TimelineMessage message) {
        return this.batchStore(message, null);
    }

    @Override
    public Future<TimelineEntry> batchStore(long sequenceId, TimelineMessage message) {
        return this.batchStore(sequenceId, message, null);
    }

    @Override
    public Future<TimelineEntry> batchStore(TimelineMessage message, TimelineCallback callback) {
        Preconditions.checkArgument(this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not auto generated.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), -1L, this.schema.isAutoGenerateSeqId());
        return this.doBatchWriteAsync(primaryKey, message, callback);
    }

    @Override
    public Future<TimelineEntry> batchStore(long sequenceId, TimelineMessage message, TimelineCallback callback) {
        Preconditions.checkArgument(!this.schema.isAutoGenerateSeqId(), "The sequence id of this timeline is not allowed to set manually.");
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, this.schema.isAutoGenerateSeqId());
        return this.doBatchWriteAsync(primaryKey, message, callback);
    }

    @Override
    public TimelineEntry update(long sequenceId, TimelineMessage message) {
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, false);
        RowUpdateChange rowChange = new RowUpdateChange(this.schema.getTableName(), primaryKey);
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.put(column);
        }
        UpdateRowRequest request = new UpdateRowRequest();
        request.setRowChange(rowChange);
        try {
            this.client.updateRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return new TimelineEntry(sequenceId, message);
    }

    @Override
    public Future<TimelineEntry> updateAsync(long sequenceId, TimelineMessage message, TimelineCallback callback) {
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, false);
        RowUpdateChange rowChange = new RowUpdateChange(this.schema.getTableName(), primaryKey);
        for (String columnName : message.getFields().keySet()) {
            Column column = message.getFields().get(columnName);
            rowChange.put(column);
        }
        rowChange.setReturnType(ReturnType.RT_PK);
        UpdateRowRequest request = new UpdateRowRequest();
        request.setRowChange(rowChange);
        return this.doUpdateAsync(sequenceId, message, request, callback);
    }

    @Override
    public TimelineEntry get(long sequenceId) {
        GetRowResponse response;
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, false);
        GetRowRequest request = new GetRowRequest();
        SingleRowQueryCriteria singleRowQueryCriteria = new SingleRowQueryCriteria(this.schema.getTableName(), primaryKey);
        singleRowQueryCriteria.setMaxVersions(1);
        request.setRowQueryCriteria(singleRowQueryCriteria);
        try {
            response = this.client.getRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return Utils.rowToTimelineEntry(this.schema, response.getRow());
    }

    @Override
    public void delete(long sequenceId) {
        PrimaryKey primaryKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), sequenceId, false);
        RowDeleteChange rowChange = new RowDeleteChange(this.schema.getTableName(), primaryKey);
        DeleteRowRequest request = new DeleteRowRequest();
        request.setRowChange(rowChange);
        try {
            this.client.deleteRow(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
    }

    @Override
    public Iterator<TimelineEntry> scan(ScanParameter parameter) {
        TimelineEntryIterator timelineEntryIterator;
        RangeIteratorParameter param = new RangeIteratorParameter(this.schema.getTableName());
        param.setMaxVersions(1);
        param.setMaxCount(parameter.getMaxCount());
        param.setDirection(parameter.isForward() ? Direction.FORWARD : Direction.BACKWARD);
        if (parameter.getFilter() != null) {
            param.setFilter(parameter.getFilter());
        }
        PrimaryKey startKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), parameter.getFrom(), false);
        PrimaryKey endKey = Utils.identifierToPrimaryKeyWithSequenceId(this.identifier, this.schema.getSequenceIdColumnName(), parameter.getTo(), false);
        param.setInclusiveStartPrimaryKey(startKey);
        param.setExclusiveEndPrimaryKey(endKey);
        try {
            timelineEntryIterator = new TimelineEntryIterator(this.client, param, this.schema);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        return timelineEntryIterator;
    }

    @Override
    public long getLatestSequenceId() {
        TimelineEntry timelineEntry = this.getLatestTimelineEntry();
        if (timelineEntry != null) {
            return timelineEntry.getSequenceID();
        }
        return 0L;
    }

    @Override
    public TimelineEntry getLatestTimelineEntry() {
        Iterator<TimelineEntry> iterator = this.scan(new ScanParameter().scanBackward(Long.MAX_VALUE, 0L).maxCount(1));
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private Future<TimelineEntry> doStoreAsync(final long sequenceId, final TimelineMessage message, PutRowRequest request, final TimelineCallback callback) {
        TableStoreCallback<PutRowRequest, PutRowResponse> tableStoreCallback = null;
        if (callback != null) {
            tableStoreCallback = new TableStoreCallback<PutRowRequest, PutRowResponse>(){

                @Override
                public void onCompleted(PutRowRequest request, PutRowResponse response) {
                    long finalSequenceId = sequenceId;
                    if (TimelineQueueImpl.this.schema.isAutoGenerateSeqId()) {
                        finalSequenceId = response.getRow().getPrimaryKey().getPrimaryKeyColumn(TimelineQueueImpl.this.schema.getSequenceIdColumnName()).getValue().asLong();
                    }
                    TimelineEntry timelineEntry = new TimelineEntry(finalSequenceId, message);
                    callback.onCompleted(TimelineQueueImpl.this.identifier, message, timelineEntry);
                }

                @Override
                public void onFailed(PutRowRequest request, Exception e) {
                    e = Utils.convertException(e);
                    callback.onFailed(TimelineQueueImpl.this.identifier, message, e);
                }
            };
        }
        final Future<PutRowResponse> future = this.asyncClient.putRow(request, tableStoreCallback);
        return new Future<TimelineEntry>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public TimelineEntry get() throws InterruptedException, ExecutionException {
                PutRowResponse response;
                try {
                    response = (PutRowResponse)future.get();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Utils.convertException(e);
                }
                return Utils.rowToTimelineEntryWithMessage(TimelineQueueImpl.this.schema, response.getRow(), message);
            }

            @Override
            public TimelineEntry get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                PutRowResponse response;
                try {
                    response = (PutRowResponse)future.get(timeout, unit);
                }
                catch (TimeoutException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Utils.convertException(e);
                }
                return Utils.rowToTimelineEntryWithMessage(TimelineQueueImpl.this.schema, response.getRow(), message);
            }
        };
    }

    private Future<TimelineEntry> doUpdateAsync(final Long sequenceId, final TimelineMessage message, UpdateRowRequest request, final TimelineCallback callback) {
        TableStoreCallback<UpdateRowRequest, UpdateRowResponse> tableStoreCallback = null;
        if (callback != null) {
            tableStoreCallback = new TableStoreCallback<UpdateRowRequest, UpdateRowResponse>(){

                @Override
                public void onCompleted(UpdateRowRequest request, UpdateRowResponse response) {
                    TimelineEntry timelineEntry = new TimelineEntry(sequenceId, message);
                    callback.onCompleted(TimelineQueueImpl.this.identifier, message, timelineEntry);
                }

                @Override
                public void onFailed(UpdateRowRequest request, Exception e) {
                    e = Utils.convertException(e);
                    callback.onFailed(TimelineQueueImpl.this.identifier, message, e);
                }
            };
        }
        final Future<UpdateRowResponse> future = this.asyncClient.updateRow(request, tableStoreCallback);
        return new Future<TimelineEntry>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public TimelineEntry get() throws InterruptedException, ExecutionException {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Utils.convertException(e);
                }
                return new TimelineEntry(sequenceId, message);
            }

            @Override
            public TimelineEntry get(long timeout, TimeUnit unit) throws TimelineException, InterruptedException, ExecutionException, TimeoutException {
                try {
                    future.get(timeout, unit);
                }
                catch (TimeoutException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw Utils.convertException(e);
                }
                return new TimelineEntry(sequenceId, message);
            }
        };
    }

    private Future<TimelineEntry> doBatchWriteAsync(PrimaryKey primaryKey, TimelineMessage message, TimelineCallback callback) {
        RowPutChangeWithCallback rowChange = Utils.messageToNewRowPutChange(this.schema.getTableName(), primaryKey, message).withTimelineIdentifier(this.identifier);
        if (callback != null) {
            rowChange.watchBy(callback);
        }
        this.writer.addRowChange(rowChange);
        return rowChange.getFuture();
    }

    @Override
    public SearchResult<TimelineEntry> search(SearchParameter searchParameter) {
        return this.search(Utils.toSearchQuery(searchParameter));
    }

    @Override
    public SearchResult<TimelineEntry> search(SearchQuery searchQuery) {
        SearchResponse response;
        Preconditions.checkArgument(this.schema.hasDataIndex(), "The store not support search cause not has data index");
        ArrayList<Query> queries = new ArrayList<Query>();
        queries.add(searchQuery.getQuery());
        for (PrimaryKeyColumn column : this.identifier.getFields()) {
            try {
                TermQuery q = new TermQuery();
                q.setFieldName(column.getName());
                q.setTerm(column.getValue().toColumnValue());
                queries.add(q);
            }
            catch (Exception e) {
                throw Utils.convertException(e);
            }
        }
        BoolQuery query = new BoolQuery();
        query.setMustQueries(queries);
        SearchQuery searchQueryCopy = searchQuery.toCopy();
        searchQueryCopy.setQuery(query);
        SearchRequest request = new SearchRequest(this.schema.getTableName(), this.schema.getIndexName(), searchQueryCopy);
        SearchRequest.ColumnsToGet columnsToGet = new SearchRequest.ColumnsToGet();
        columnsToGet.setReturnAll(true);
        request.setColumnsToGet(columnsToGet);
        try {
            response = this.client.search(request);
        }
        catch (Exception e) {
            throw Utils.convertException(e);
        }
        ArrayList entries = new ArrayList(response.getRows().size());
        for (Row row : response.getRows()) {
            TimelineEntry entry = Utils.rowToTimelineEntry(this.schema, row);
            TimelineIdentifier identifier = Utils.primaryKeyToIdentifier(this.schema.getIdentifierSchema(), row.getPrimaryKey());
            SearchResult.Entry<TimelineEntry> se = new SearchResult.Entry<TimelineEntry>(identifier, entry);
            entries.add(se);
        }
        SearchResult<TimelineEntry> result = new SearchResult<TimelineEntry>(entries, response.isAllSuccess(), response.getTotalCount(), response.getNextToken());
        return result;
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() {
    }
}

