/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timeline.model;

import com.alicloud.openservices.tablestore.model.search.IndexSchema;
import com.alicloud.openservices.tablestore.timeline.model.TimelineIdentifierSchema;
import com.alicloud.openservices.tablestore.writer.WriterConfig;

public class TimelineSchema {
    public static final String SEQUENCE_ID_COLUMN_NAME = "sequence_id";
    private String tableName;
    private String indexName;
    private TimelineIdentifierSchema identifierSchema;
    private SequenceIdGeneration sequenceIdGeneration = SequenceIdGeneration.AUTO_INCREMENT;
    private String sequenceIdColumnName = "sequence_id";
    private int ttl = -1;
    private IndexSchema indexSchema;
    private int maxCallbackExecuteThreads = Runtime.getRuntime().availableProcessors() + 1;
    private int callbackExecuteThreads = this.maxCallbackExecuteThreads / 2;
    private WriterConfig writerConfig;

    public TimelineSchema(String tableName, TimelineIdentifierSchema identifierSchema) {
        this.tableName = tableName;
        this.identifierSchema = identifierSchema;
        this.writerConfig = new WriterConfig();
    }

    public TimelineSchema autoGenerateSeqId() {
        this.sequenceIdGeneration = SequenceIdGeneration.AUTO_INCREMENT;
        return this;
    }

    public TimelineSchema manualSetSeqId() {
        this.sequenceIdGeneration = SequenceIdGeneration.MANUAL;
        return this;
    }

    public TimelineSchema withIndex(String indexName, IndexSchema dataIndex) {
        this.indexName = indexName;
        this.indexSchema = dataIndex;
        return this;
    }

    public TimelineSchema setTimeToLive(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public TimelineSchema setSequenceIdColumnName(String sequenceIdColumnName) {
        this.sequenceIdColumnName = sequenceIdColumnName;
        return this;
    }

    public TimelineSchema withWriterConfig(WriterConfig writerConfig) {
        this.writerConfig = writerConfig;
        return this;
    }

    public TimelineSchema setCallbackExecuteThreads(int callbackExecuteThreads) {
        this.callbackExecuteThreads = callbackExecuteThreads;
        if (callbackExecuteThreads > this.maxCallbackExecuteThreads) {
            this.maxCallbackExecuteThreads = callbackExecuteThreads;
        }
        return this;
    }

    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    public String getSequenceIdColumnName() {
        return this.sequenceIdColumnName;
    }

    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean hasDataIndex() {
        return this.indexName != null && this.indexSchema != null;
    }

    public TimelineIdentifierSchema getIdentifierSchema() {
        return this.identifierSchema;
    }

    public boolean isAutoGenerateSeqId() {
        return this.sequenceIdGeneration == SequenceIdGeneration.AUTO_INCREMENT;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public IndexSchema getIndexSchema() {
        return this.indexSchema;
    }

    public int getMaxCallbackExecuteThreads() {
        return this.maxCallbackExecuteThreads;
    }

    public int getCallbackExecuteThreads() {
        return this.callbackExecuteThreads;
    }

    public static enum SequenceIdGeneration {
        AUTO_INCREMENT,
        MANUAL;

    }
}

