/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.filter;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.OptionalValue;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.FilterType;
import com.alicloud.openservices.tablestore.model.filter.RegexRule;
import com.google.protobuf.ByteString;

public class SingleColumnValueRegexFilter
extends ColumnValueFilter {
    private CompareOperator operator;
    private String columnName;
    private ColumnValue columnValue;
    private boolean latestVersionsOnly = true;
    private OptionalValue<RegexRule> regexRule = new OptionalValue("RegexRule");

    public SingleColumnValueRegexFilter(String columnName, RegexRule rule, CompareOperator operator, ColumnValue columnValue) {
        if (operator == CompareOperator.EXIST || operator == CompareOperator.NOT_EXIST) {
            throw new ClientException("operator " + operator.name() + " should not use in this construct function");
        }
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(columnValue);
        this.setRegexRule(rule);
    }

    public SingleColumnValueRegexFilter(String columnName, RegexRule rule, CompareOperator operator) {
        if (operator != CompareOperator.EXIST && operator != CompareOperator.NOT_EXIST) {
            throw new ClientException("operator " + operator.name() + " should not use in this construct function");
        }
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(ColumnValue.fromLong(0L));
        this.setRegexRule(rule);
    }

    public SingleColumnValueRegexFilter(String columnName, CompareOperator operator, ColumnValue columnValue) {
        if (operator == CompareOperator.EXIST || operator == CompareOperator.NOT_EXIST) {
            throw new ClientException("operator " + operator.name() + " should not use in this construct function");
        }
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(columnValue);
    }

    public SingleColumnValueRegexFilter(String columnName, CompareOperator operator) {
        if (operator != CompareOperator.EXIST && operator != CompareOperator.NOT_EXIST) {
            throw new ClientException("operator " + operator.name() + " should not use in this construct function");
        }
        this.setColumnName(columnName);
        this.setOperator(operator);
        this.setColumnValue(ColumnValue.fromLong(0L));
    }

    private SingleColumnValueRegexFilter setOperator(CompareOperator operator) {
        Preconditions.checkNotNull(operator, "The operator should not be null.");
        this.operator = operator;
        return this;
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    private SingleColumnValueRegexFilter setColumnName(String columnName) {
        Preconditions.checkArgument(columnName != null && !columnName.isEmpty(), "The name of column should not be null or empty.");
        this.columnName = columnName;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    private SingleColumnValueRegexFilter setColumnValue(ColumnValue columnValue) {
        Preconditions.checkNotNull(columnValue, "The value of column should not be null.");
        this.columnValue = columnValue;
        return this;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    private SingleColumnValueRegexFilter setRegexRule(RegexRule rule) {
        this.regexRule.setValue(rule);
        return this;
    }

    public boolean hasRegexRule() {
        return this.regexRule.isValueSet();
    }

    public RegexRule getRegexRule() {
        return this.regexRule.getValue();
    }

    public SingleColumnValueRegexFilter setLatestVersionsOnly(boolean latestVersionsOnly) {
        this.latestVersionsOnly = latestVersionsOnly;
        return this;
    }

    public boolean getLatestVersionsOnly() {
        return this.latestVersionsOnly;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SINGLE_COLUMN_VALUE_FILTER;
    }

    @Override
    public ByteString serialize() {
        return OTSProtocolBuilder.buildSingleColumnValueRegexFilter(this);
    }

    public static enum CompareOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        GREATER_EQUAL,
        LESS_THAN,
        LESS_EQUAL,
        EXIST,
        NOT_EXIST;

    }
}

