/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.ecosystem.GeoType;
import com.google.gson.Gson;
import java.util.List;

public class GeoQueryHelper {
    private static final Gson GSON = new Gson();
    private String fieldName;
    private String centerPoint;
    private double distanceInMeter;
    private String topLeft;
    private String bottomRight;
    private List<String> points;
    private GeoType geoType;

    public static GeoQueryHelper buildGeoQueryHelper(Filter filter) {
        if (filter.getCompareOperator() != Filter.CompareOperator.EQUAL) {
            throw new IllegalArgumentException("geo column only support = json string,example: geoColumn = {centerPoint:6,9, distanceInMeter: 10000}");
        }
        String json = filter.getColumnValue().toString();
        GeoQueryHelper geoQuery = (GeoQueryHelper)GSON.fromJson(json, GeoQueryHelper.class);
        if (geoQuery.getCenterPoint() != null && geoQuery.getDistanceInMeter() >= 0.0) {
            geoQuery.setGeoType(GeoType.DISTANCE);
        } else if (geoQuery.getTopLeft() != null && geoQuery.getBottomRight() != null) {
            geoQuery.setGeoType(GeoType.BOUNDING_BOX);
        } else if (geoQuery.getPoints() != null && !geoQuery.getPoints().isEmpty()) {
            geoQuery.setGeoType(GeoType.POLYGON);
        } else {
            throw new IllegalArgumentException("geo query must be distance, boundingbox or polygon format");
        }
        return geoQuery;
    }

    public GeoType getGeoType() {
        return this.geoType;
    }

    public void setGeoType(GeoType geoType) {
        this.geoType = geoType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getCenterPoint() {
        return this.centerPoint;
    }

    public void setCenterPoint(String centerPoint) {
        this.centerPoint = centerPoint;
    }

    public double getDistanceInMeter() {
        return this.distanceInMeter;
    }

    public void setDistanceInMeter(double distanceInMeter) {
        this.distanceInMeter = distanceInMeter;
    }

    public String getTopLeft() {
        return this.topLeft;
    }

    public void setTopLeft(String topLeft) {
        this.topLeft = topLeft;
    }

    public String getBottomRight() {
        return this.bottomRight;
    }

    public void setBottomRight(String bottomRight) {
        this.bottomRight = bottomRight;
    }

    public List<String> getPoints() {
        return this.points;
    }

    public void setPoints(List<String> points) {
        this.points = points;
    }
}

