/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.timeseries;

import com.alicloud.openservices.tablestore.core.protocol.timeseries.TimeseriesProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TimeseriesKey {
    private final String measurementName;
    private final String dataSource;
    private final SortedMap<String, String> tags = new TreeMap<String, String>();
    private String tagsString;

    public TimeseriesKey(String measurementName, String dataSource) {
        this(measurementName, dataSource, null);
    }

    public TimeseriesKey(String measurementName, Map<String, String> tags) {
        this(measurementName, "", tags);
    }

    public TimeseriesKey(String measurementName, String dataSource, Map<String, String> tags) {
        Preconditions.checkStringNotNullAndEmpty(measurementName, "measurement should not be null or empty");
        this.measurementName = measurementName;
        this.dataSource = dataSource != null ? dataSource : "";
        if (tags != null) {
            this.tags.putAll(tags);
        }
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public SortedMap<String, String> getTags() {
        return Collections.unmodifiableSortedMap(this.tags);
    }

    public String buildTagsString() {
        if (this.tagsString == null) {
            this.tagsString = TimeseriesProtocolBuilder.buildTagsString(this.tags);
            return this.tagsString;
        }
        return this.tagsString;
    }

    public String buildMetaCacheKey(String tableName) {
        StringBuilder sb = new StringBuilder(tableName.length() + this.measurementName.length() + this.dataSource.length() + this.buildTagsString().length() + 3);
        sb.append(tableName);
        sb.append('\t');
        sb.append(this.measurementName);
        sb.append('\t');
        sb.append(this.dataSource);
        sb.append('\t');
        sb.append(this.buildTagsString());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeseriesKey that = (TimeseriesKey)o;
        return Objects.equal((Object)this.measurementName, (Object)that.measurementName) && Objects.equal((Object)this.dataSource, (Object)that.dataSource) && Objects.equal(this.tags, that.tags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.measurementName, this.dataSource, this.tags});
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

