/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.query;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.model.search.SearchQuery;
import com.alicloud.openservices.tablestore.model.search.SearchRequest;
import com.alicloud.openservices.tablestore.model.search.query.MatchAllQuery;
import com.alicloud.openservices.tablestore.model.search.sort.Sort;
import com.alicloud.openservices.tablestore.timestream.model.TimestreamMetaIterator;
import com.alicloud.openservices.tablestore.timestream.model.filter.Filter;
import com.alicloud.openservices.tablestore.timestream.model.query.Sorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaFilter {
    static Logger logger = LoggerFactory.getLogger(MetaFilter.class);
    private AsyncClient asyncClient;
    private String metaTableName;
    private String indexName;
    private Filter filter;
    private boolean returnAll = false;
    private List<String> attrToGet = null;
    private int limit = 100;
    private int offset = 0;
    private Sort sort = null;

    public MetaFilter(AsyncClient asyncClient, String metaTableName, String indexName, Filter filter) {
        this.asyncClient = asyncClient;
        this.metaTableName = metaTableName;
        this.indexName = indexName;
        this.filter = filter;
    }

    public MetaFilter limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MetaFilter offset(int offset) {
        this.offset = offset;
        return this;
    }

    public MetaFilter sort(Sorter sorter) {
        this.sort = new Sort(sorter.getSorter());
        return this;
    }

    public MetaFilter selectAttributes(String ... columns) {
        if (this.returnAll) {
            throw new ClientException("returnAll has been set.");
        }
        this.attrToGet = Arrays.asList(columns);
        return this;
    }

    public List<String> getAttributesToSelect() {
        return this.attrToGet;
    }

    public MetaFilter returnAll() {
        if (this.attrToGet != null) {
            throw new ClientException("Attributes to select has been set.");
        }
        this.returnAll = true;
        return this;
    }

    public boolean isReturnAll() {
        return this.returnAll;
    }

    public boolean getReturnAll() {
        return this.returnAll;
    }

    private TimestreamMetaIterator fetchMeta(List<String> colsToGet) {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.setLimit(this.limit);
        searchQuery.setOffset(this.offset);
        searchQuery.setGetTotalCount(true);
        if (this.filter == null) {
            searchQuery.setQuery(new MatchAllQuery());
        } else {
            searchQuery.setQuery(this.filter.getQuery());
        }
        if (this.sort != null) {
            searchQuery.setSort(this.sort);
        }
        SearchRequest request = new SearchRequest(this.metaTableName, this.indexName, searchQuery);
        SearchRequest.ColumnsToGet columnsToGet = new SearchRequest.ColumnsToGet();
        if (colsToGet != null) {
            columnsToGet.setColumns(colsToGet);
        } else {
            columnsToGet.setReturnAll(true);
        }
        request.setColumnsToGet(columnsToGet);
        return new TimestreamMetaIterator(this.asyncClient, request);
    }

    public TimestreamMetaIterator fetchAll() {
        ArrayList<String> colsToGet = null;
        if (!this.returnAll) {
            if (this.attrToGet != null) {
                colsToGet = new ArrayList<String>();
                colsToGet.addAll(this.attrToGet);
                colsToGet.add("s");
            } else {
                colsToGet = new ArrayList();
                colsToGet.add("s");
            }
        }
        return this.fetchMeta(colsToGet);
    }
}

