/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.utils;

import com.aliyun.oss.ServiceException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LoggerUtils {
    private static final Logger logger = Logger.getLogger((String)"com.aliyun.oss");
    private static List<String> errorCodeFilterList = new ArrayList<String>();

    public static Logger getLogger() {
        return logger;
    }

    public static void setLevel(String levelAsString) {
        Level lvl = Level.toLevel((String)levelAsString, (Level)Level.DEBUG);
        LogManager.getRootLogger().setLevel(lvl);
        LogManager.getLogger((String)"com.aliyun.oss").setLevel(lvl);
    }

    public static String getLevel() {
        return logger.getLevel().toString();
    }

    public static <ExType> void logException(String messagePrefix, ExType ex) {
        assert (ex instanceof Exception);
        String detailMessage = messagePrefix + ((Exception)ex).getMessage();
        if (ex instanceof ServiceException && errorCodeFilterList.contains(((ServiceException)ex).getErrorCode())) {
            logger.info((Object)detailMessage);
        } else {
            logger.warn((Object)detailMessage);
        }
    }

    static {
        errorCodeFilterList.add("NoSuchBucket");
        errorCodeFilterList.add("NoSuchKey");
        errorCodeFilterList.add("NoSuchUpload");
        errorCodeFilterList.add("NoSuchCORSConfiguration");
        errorCodeFilterList.add("NoSuchWebsiteConfiguration");
        errorCodeFilterList.add("NoSuchLifecycle");
    }
}

