/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AccessControlList;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.BucketLoggingResult;
import com.aliyun.oss.model.BucketReferer;
import com.aliyun.oss.model.BucketWebsiteResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.LifecycleRule;
import com.aliyun.oss.model.ListBucketsRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.SetBucketAclRequest;
import com.aliyun.oss.model.SetBucketLifecycleRequest;
import com.aliyun.oss.model.SetBucketLoggingRequest;
import com.aliyun.oss.model.SetBucketRefererRequest;
import com.aliyun.oss.model.SetBucketWebsiteRequest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSSBucketOperation
extends OSSOperation {
    public OSSBucketOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createBucketRequest, "createBucketRequest");
        String bucketName = createBucketRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, createBucketRequest.getCannedACL());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setInputStreamWithLength(RequestMarshallers.createBucketRequestMarshaller.marshall(createBucketRequest)).setOriginalRequest(createBucketRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
        return new Bucket(bucketName);
    }

    public void deleteBucket(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<Bucket> listBuckets() throws OSSException, ClientException {
        BucketList bucketList = this.listBuckets(new ListBucketsRequest(null, null, null));
        List<Bucket> buckets = bucketList.getBucketList();
        while (bucketList.isTruncated()) {
            bucketList = this.listBuckets(new ListBucketsRequest(null, bucketList.getNextMarker(), null));
            buckets.addAll(bucketList.getBucketList());
        }
        return buckets;
    }

    public BucketList listBuckets(ListBucketsRequest listBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listBucketRequest, "listBucketRequest");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (listBucketRequest.getPrefix() != null) {
            params.put("prefix", listBucketRequest.getPrefix());
        }
        if (listBucketRequest.getMarker() != null) {
            params.put("marker", listBucketRequest.getMarker());
        }
        if (listBucketRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listBucketRequest.getMaxKeys()));
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(listBucketRequest).build();
        return this.doOperation(request, ResponseParsers.listBucketResponseParser, null, null, true);
    }

    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketAclRequest, "setBucketAclRequest");
        String bucketName = setBucketAclRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, setBucketAclRequest.getCannedACL());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setOriginalRequest(setBucketAclRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public AccessControlList getBucketAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketAclResponseParser, bucketName, null, true);
    }

    public void setBucketReferer(SetBucketRefererRequest setBucketRefererRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketRefererRequest, "setBucketRefererRequest");
        String bucketName = setBucketRefererRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        BucketReferer referer = setBucketRefererRequest.getReferer();
        if (referer == null) {
            referer = new BucketReferer();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketRefererMarshaller.marshall(referer)).setOriginalRequest(setBucketRefererRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketReferer getBucketReferer(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketRefererResponseParser, bucketName, null, true);
    }

    public String getBucketLocation(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("location", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLocationResponseParser, bucketName, null, true);
    }

    public boolean doesBucketExists(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        try {
            this.getBucketAcl(new GenericRequest(bucketName));
        }
        catch (OSSException oe) {
            if (oe.getErrorCode().equals("NoSuchBucket")) {
                return false;
            }
        }
        catch (Exception e) {
            System.err.println("doesBucketExists " + e.getMessage());
        }
        return true;
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listObjectsRequest, "listObjectsRequest");
        String bucketName = listObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListObjectsRequestParameters(listObjectsRequest, params);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(listObjectsRequest).build();
        return this.doOperation(request, ResponseParsers.listObjectsReponseParser, bucketName, null, true);
    }

    public void setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLoggingRequest, "setBucketLoggingRequest");
        String bucketName = setBucketLoggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLoggingRequestMarshaller.marshall(setBucketLoggingRequest)).setOriginalRequest(setBucketLoggingRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketLoggingResult getBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLoggingResponseParser, bucketName, null, true);
    }

    public void deleteBucketLogging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketWebSiteRequest, "setBucketWebSiteRequest");
        String bucketName = setBucketWebSiteRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        String indexDocument = setBucketWebSiteRequest.getIndexDocument();
        CodingUtils.assertParameterNotNull(indexDocument, "indexDocument");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketWebsiteRequestMarshaller.marshall(setBucketWebSiteRequest)).setOriginalRequest(setBucketWebSiteRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketWebsiteResult getBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketWebsiteResponseParser, bucketName, null, true);
    }

    public void deleteBucketWebsite(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLifecycleRequest, "setBucketLifecycleRequest");
        String bucketName = setBucketLifecycleRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLifecycleRequestMarshaller.marshall(setBucketLifecycleRequest)).setOriginalRequest(setBucketLifecycleRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<LifecycleRule> getBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getBucketLifecycleResponseParser, bucketName, null, true);
    }

    public void deleteBucketLifecycle(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    private static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    private static void addOptionalACLHeader(Map<String, String> headers, CannedAccessControlList cannedAcl) {
        if (cannedAcl != null) {
            headers.put("x-oss-acl", cannedAcl.toString());
        }
    }
}

