/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.builder.signing;

public class KeytoolException extends Exception {
    /** default serial uid */
    private static final long serialVersionUID = 1L;
    private String mJavaHome = null;
    private String mCommandLine = null;

    KeytoolException(String message) {
        super(message);
    }

    KeytoolException(String message, Throwable t) {
        super(message, t);
    }

    KeytoolException(String message, String javaHome, String commandLine) {
        super(message);

        mJavaHome = javaHome;
        mCommandLine = commandLine;
    }

    public String getJavaHome() {
        return mJavaHome;
    }

    public String getCommandLine() {
        return mCommandLine;
    }

}
