/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.ManifestParser;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.InputSource;

public class DefaultManifestParser
implements ManifestParser {
    @Override
    @Nullable
    public String getPackage(@NonNull File manifestFile) {
        return DefaultManifestParser.getStringValue(manifestFile, "/manifest/@package");
    }

    @Override
    @Nullable
    public String getVersionName(@NonNull File manifestFile) {
        return DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionName");
    }

    @Override
    public int getVersionCode(@NonNull File manifestFile) {
        try {
            String value = DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionCode");
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getMinSdkVersion(@NonNull File manifestFile) {
        try {
            Object value = AndroidManifest.getMinSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (!(value instanceof String)) return 1;
        }
        catch (XPathExpressionException e) {
            return 1;
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    @Override
    public int getTargetSdkVersion(@NonNull File manifestFile) {
        try {
            Integer value = AndroidManifest.getTargetSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
            if (value != null) {
                return value;
            }
            return -1;
        }
        catch (XPathExpressionException e) {
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return -1;
    }

    private static String getStringValue(@NonNull File file, @NonNull String xPath) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            InputSource source = new InputSource(XmlUtils.getUtfReader((File)file));
            return xpath.evaluate(xPath, source);
        }
        catch (XPathExpressionException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

