/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.TickException;
import java.io.File;

public class NinePatchException
extends Exception {
    @NonNull
    private final File mFile;
    private final TickException mTickException;
    private final String mEdge;

    NinePatchException(@NonNull File file, @NonNull TickException tickException, @NonNull String edge) {
        this.mFile = file;
        this.mTickException = tickException;
        this.mEdge = edge;
    }

    NinePatchException(@NonNull File file, String message) {
        super(message);
        this.mFile = file;
        this.mTickException = null;
        this.mEdge = null;
    }

    String getEdge() {
        return this.mEdge;
    }

    TickException getTickException() {
        return this.mTickException;
    }

    @Override
    public String getMessage() {
        if (this.mTickException != null) {
            String info = this.mTickException.getPixelColor() != null && this.mTickException.getPixelLocation() >= 0 ? String.format("Found at pixel #%d with color 0x%08X along %s edge", this.mTickException.getPixelLocation(), this.mTickException.getPixelColor(), this.mEdge) : String.format("Found along %s edge", this.mEdge);
            return String.format("%s: Error: 9-patch image malformed:\n       %s\n       %s", this.mFile, this.mTickException.getMessage(), info);
        }
        return String.format("%s: Error: 9-patch image malformed: %s", this.mFile, super.getMessage());
    }
}

