/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.TestException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @Nullable File testedApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeout, @NonNull File resultsDir, @NonNull File coverageDir, @NonNull ILogger logger) throws TestException, InterruptedException {
        int n;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        for (DeviceConnector deviceConnector : deviceList) {
            if (!this.filterOutDevice(deviceConnector, testData, logger, projectName, variantName)) continue;
            executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, testedApk, testData, resultsDir, coverageDir, timeout, logger));
        }
        List results = executor.waitForAllTasks();
        boolean bl = true;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= (Boolean)result.value == false ? 1 : 0;
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }

    private boolean filterOutDevice(@NonNull DeviceConnector device, @NonNull TestData testData, @NonNull ILogger logger, @NonNull String projectName, @NonNull String variantName) {
        int deviceApiLevel = device.getApiLevel();
        if (deviceApiLevel == 0) {
            logger.info("Skipping device '%s' for '%s:%s': Unknown API Level", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        if (testData.getMinSdkVersion() > deviceApiLevel) {
            logger.info("Skipping device '%s' for '%s:%s'", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        Set<String> appAbis = testData.getSupportedAbis();
        if (appAbis != null && !appAbis.isEmpty()) {
            List deviceAbis = device.getAbis();
            if (deviceAbis == null || deviceAbis.isEmpty()) {
                logger.info("Skipping device '%s' for '%s:%s': Unknown ABI", new Object[]{device.getName(), projectName, variantName});
                return false;
            }
            boolean compatibleAbi = false;
            for (String deviceAbi : deviceAbis) {
                if (!appAbis.contains(deviceAbi)) continue;
                compatibleAbi = true;
            }
            if (!compatibleAbi) {
                return false;
            }
        }
        return true;
    }
}

