/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.utils.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class SimpleTestCallable
implements Callable<Boolean> {
    public static final String FILE_COVERAGE_EC = "coverage.ec";
    @NonNull
    private final String projectName;
    @NonNull
    private final DeviceConnector device;
    @NonNull
    private final String flavorName;
    @NonNull
    private final TestData testData;
    @NonNull
    private final File resultsDir;
    @NonNull
    private final File coverageDir;
    @NonNull
    private final File testApk;
    @Nullable
    private final File testedApk;
    private final int timeout;
    @NonNull
    private final ILogger logger;

    public SimpleTestCallable(@NonNull DeviceConnector device, @NonNull String projectName, @NonNull String flavorName, @NonNull File testApk, @Nullable File testedApk, @NonNull TestData testData, @NonNull File resultsDir, @NonNull File coverageDir, int timeout, @NonNull ILogger logger) {
        this.projectName = projectName;
        this.device = device;
        this.flavorName = flavorName;
        this.resultsDir = resultsDir;
        this.coverageDir = coverageDir;
        this.testApk = testApk;
        this.testedApk = testedApk;
        this.testData = testData;
        this.timeout = timeout;
        this.logger = logger;
    }

    @Override
    public Boolean call() throws Exception {
        String deviceName = this.device.getName();
        boolean isInstalled = false;
        CustomTestRunListener runListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
        runListener.setReportDir(this.resultsDir);
        long time = System.currentTimeMillis();
        boolean success = false;
        String coverageFile = "/data/data/" + this.testData.getTestedApplicationId() + "/" + FILE_COVERAGE_EC;
        try {
            this.device.connect(this.timeout, this.logger);
            if (this.testedApk != null) {
                this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testedApk});
                this.device.installPackage(this.testedApk, this.timeout, this.logger);
            }
            this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testApk});
            this.device.installPackage(this.testApk, this.timeout, this.logger);
            isInstalled = true;
            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.testData.getApplicationId(), this.testData.getInstrumentationRunner(), (IShellEnabledDevice)this.device);
            if (this.testData.isTestCoverageEnabled()) {
                runner.addInstrumentationArg("coverage", "true");
                runner.addInstrumentationArg("coverageFile", coverageFile);
            }
            runner.setRunName(deviceName);
            runner.setMaxtimeToOutputResponse(this.timeout);
            runner.run(new ITestRunListener[]{runListener});
            boolean result = runListener.getRunResult().hasFailedTests();
            success = true;
            Boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            Map<String, String> emptyMetrics = Collections.emptyMap();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, true);
            e.printStackTrace(pw);
            TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "runTests");
            runListener.testStarted(fakeTest);
            runListener.testFailed(ITestRunListener.TestFailure.ERROR, fakeTest, baos.toString());
            runListener.testEnded(fakeTest, emptyMetrics);
            runListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
            throw e;
        }
        finally {
            if (isInstalled) {
                if (success && this.testData.isTestCoverageEnabled()) {
                    this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " chmod 644 " + coverageFile, (IShellOutputReceiver)new NullOutputReceiver(), 30L, TimeUnit.SECONDS);
                    this.device.pullFile(coverageFile, new File(this.coverageDir, FILE_COVERAGE_EC).getPath());
                }
                this.uninstall(this.testApk, this.testData.getApplicationId(), deviceName);
                if (this.testedApk != null) {
                    this.uninstall(this.testedApk, this.testData.getTestedApplicationId(), deviceName);
                }
            }
            this.device.disconnect(this.timeout, this.logger);
        }
    }

    private void uninstall(@NonNull File apkFile, @Nullable String packageName, @NonNull String deviceName) throws DeviceException {
        if (packageName != null) {
            this.logger.verbose("DeviceConnector '%s': uninstalling %s", new Object[]{deviceName, packageName});
            this.device.uninstallPackage(packageName, this.timeout, this.logger);
        } else {
            this.logger.verbose("DeviceConnector '%s': unable to uninstall %s: unable to get package name", new Object[]{deviceName, apkFile});
        }
    }
}

