/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ConnectedDevice
extends DeviceConnector {
    private final IDevice iDevice;

    public ConnectedDevice(@NonNull IDevice iDevice) {
        this.iDevice = iDevice;
    }

    @NonNull
    public String getName() {
        String model;
        String version = this.iDevice.getProperty("ro.build.version.release");
        boolean emulator = this.iDevice.isEmulator();
        String name = emulator ? (this.iDevice.getAvdName() != null ? this.iDevice.getAvdName() + "(AVD)" : this.iDevice.getSerialNumber()) : ((model = this.iDevice.getProperty("ro.product.model")) != null ? model : this.iDevice.getSerialNumber());
        return version != null ? name + " - " + version : name;
    }

    public void connect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void disconnect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void installPackage(@NonNull File apkFile, int timeout, ILogger logger) throws DeviceException {
        try {
            this.iDevice.installPackage(apkFile.getAbsolutePath(), true, new String[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to install " + apkFile.getAbsolutePath(), new Object[0]);
            throw new DeviceException((Throwable)e);
        }
    }

    public void uninstallPackage(@NonNull String packageName, int timeout, ILogger logger) throws DeviceException {
        try {
            this.iDevice.uninstallPackage(packageName);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to uninstall " + packageName, new Object[0]);
            throw new DeviceException((Throwable)e);
        }
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.iDevice.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    public void pullFile(String remote, String local) throws IOException {
        try {
            this.iDevice.pullFile(remote, local);
        }
        catch (TimeoutException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
        catch (AdbCommandRejectedException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
        catch (SyncException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
    }

    public int getApiLevel() {
        String sdkVersion = this.iDevice.getProperty("ro.build.version.sdk");
        if (sdkVersion != null) {
            try {
                return Integer.valueOf(sdkVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getApiCodeName() {
        String codeName = this.iDevice.getProperty("ro.build.version.codename");
        if (codeName != null) {
            if ("REL".equals(codeName)) {
                return null;
            }
            return codeName;
        }
        return null;
    }

    @Nullable
    public IDevice.DeviceState getState() {
        return this.iDevice.getState();
    }

    @NonNull
    public List<String> getAbis() {
        ArrayList abis = Lists.newArrayListWithExpectedSize((int)2);
        String abi = this.iDevice.getProperty("ro.product.cpu.abi");
        if (abi != null) {
            abis.add(abi);
        }
        if ((abi = this.iDevice.getProperty("ro.product.cpu.abi2")) != null) {
            abis.add(abi);
        }
        return abis;
    }

    public int getDensity() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }
}

