/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.model.ApiVersion;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.sdk.SdkVersionInfo;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @Nullable File testedApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeout, @NonNull File resultsDir, @NonNull File coverageDir, @NonNull ILogger logger) throws TestException, TestRunner.NoAuthorizedDeviceFoundException, InterruptedException {
        int n;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        boolean foundAtLeastOneAuthorizedDevice = false;
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() == IDevice.DeviceState.UNAUTHORIZED) continue;
            foundAtLeastOneAuthorizedDevice = true;
            if (!this.filterOutDevice(deviceConnector, testData, logger, projectName, variantName)) continue;
            executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, testedApk, testData, resultsDir, coverageDir, timeout, logger));
        }
        if (!foundAtLeastOneAuthorizedDevice) {
            throw new TestRunner.NoAuthorizedDeviceFoundException();
        }
        List results = executor.waitForAllTasks();
        boolean bl = true;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= (Boolean)result.value == false ? 1 : 0;
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }

    private boolean filterOutDevice(@NonNull DeviceConnector device, @NonNull TestData testData, @NonNull ILogger logger, @NonNull String projectName, @NonNull String variantName) {
        Set<String> appAbis;
        int minSdkVersion;
        int deviceApiLevel = device.getApiLevel();
        if (deviceApiLevel == 0) {
            logger.info("Skipping device '%1$s' for '%2$s:%3$s': Unknown API Level", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        ApiVersion apiVersion = testData.getMinSdkVersion();
        int n = minSdkVersion = apiVersion == null ? 1 : apiVersion.getApiLevel();
        if (apiVersion != null && apiVersion.getCodename() != null) {
            String deviceCodeName = device.getApiCodeName();
            if (deviceCodeName != null) {
                if (deviceCodeName.equals(apiVersion.getCodename())) {
                    logger.info("Skipping device '%1$s', due to different API preview '%2$s' and '%3$s'", new Object[]{device.getName(), deviceCodeName, apiVersion.getCodename()});
                    return false;
                }
            } else {
                minSdkVersion = SdkVersionInfo.getApiByBuildCode((String)apiVersion.getCodename(), (boolean)true);
                if (minSdkVersion > deviceApiLevel) {
                    logger.info("Skipping device '%s' for '%s:%s'", new Object[]{device.getName(), projectName, variantName});
                    return false;
                }
            }
        } else if (minSdkVersion > deviceApiLevel) {
            logger.info("Skipping device '%s' for '%s:%s'", new Object[]{device.getName(), projectName, variantName});
            return false;
        }
        if ((appAbis = testData.getSupportedAbis()) != null && !appAbis.isEmpty()) {
            List deviceAbis = device.getAbis();
            if (deviceAbis.isEmpty()) {
                logger.info("Skipping device '%s' for '%s:%s': Unknown ABI", new Object[]{device.getName(), projectName, variantName});
                return false;
            }
            boolean compatibleAbi = false;
            for (String deviceAbi : deviceAbis) {
                if (!appAbis.contains(deviceAbi)) continue;
                compatibleAbi = true;
            }
            if (!compatibleAbi) {
                return false;
            }
        }
        return true;
    }
}

