/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.ManifestParser;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.InputSource;

public class DefaultManifestParser
implements ManifestParser {
    @Override
    @Nullable
    public String getPackage(@NonNull File manifestFile) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            return xpath.evaluate("/manifest/@package", new InputSource(new FileInputStream(manifestFile)));
        }
        catch (XPathExpressionException e) {
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    @Nullable
    public String getVersionName(@NonNull File manifestFile) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            return xpath.evaluate("/manifest/@android:versionName", new InputSource(new FileInputStream(manifestFile)));
        }
        catch (XPathExpressionException e) {
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getMinSdkVersion(@NonNull File manifestFile) {
        try {
            Object value = AndroidManifest.getMinSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (!(value instanceof String)) return 1;
        }
        catch (XPathExpressionException e) {
            return 1;
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    @Override
    public int getTargetSdkVersion(@NonNull File manifestFile) {
        try {
            Integer value = AndroidManifest.getTargetSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
            if (value != null) {
                return value;
            }
            return -1;
        }
        catch (XPathExpressionException e) {
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return -1;
    }
}

