/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.DefaultBuildType;
import com.android.builder.DefaultManifestParser;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.ManifestParser;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.internal.MergedNdkConfig;
import com.android.builder.internal.StringHelper;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.android.builder.model.NdkConfig;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.TestData;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.ResourceSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantConfiguration
implements TestData {
    private static final ManifestParser sManifestParser = new DefaultManifestParser();
    private String mFullName;
    private String mFlavorName;
    private String mBaseName;
    private String mDirName;
    @NonNull
    private final DefaultProductFlavor mDefaultConfig;
    @NonNull
    private final SourceProvider mDefaultSourceProvider;
    @NonNull
    private final DefaultBuildType mBuildType;
    @Nullable
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<String> mFlavorDimensionNames = Lists.newArrayList();
    private final List<DefaultProductFlavor> mFlavorConfigs = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    @Nullable
    private SourceProvider mVariantSourceProvider;
    @Nullable
    private SourceProvider mMultiFlavorSourceProvider;
    @NonNull
    private final Type mType;
    private final VariantConfiguration mTestedConfig;
    private LibraryDependency mOutput;
    private DefaultProductFlavor mMergedFlavor;
    private final MergedNdkConfig mMergedNdkConfig = new MergedNdkConfig();
    private final Set<JarDependency> mJars = Sets.newHashSet();
    private final List<LibraryDependency> mDirectLibraries = Lists.newArrayList();
    private final List<LibraryDependency> mFlatLibraries = Lists.newArrayList();
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";
    private static final Boolean DEFAULT_HANDLE_PROFILING = false;
    private static final Boolean DEFAULT_FUNCTIONAL_TEST = false;

    @Nullable
    public static String getManifestPackage(@NonNull File manifestFile) {
        return sManifestParser.getPackage(manifestFile);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, @Nullable SourceProvider buildTypeSourceProvider) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, Type.DEFAULT, null);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull Type type) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, null);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable VariantConfiguration testedConfig) {
        this.mDefaultConfig = (DefaultProductFlavor)Preconditions.checkNotNull((Object)defaultConfig);
        this.mDefaultSourceProvider = (SourceProvider)Preconditions.checkNotNull((Object)defaultSourceProvider);
        this.mBuildType = (DefaultBuildType)Preconditions.checkNotNull((Object)buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mTestedConfig = testedConfig;
        Preconditions.checkState((this.mType != Type.TEST || this.mTestedConfig != null ? 1 : 0) != 0);
        this.mMergedFlavor = this.mDefaultConfig;
        this.computeNdkConfig();
        if (testedConfig != null && testedConfig.mType == Type.LIBRARY && testedConfig.mOutput != null) {
            this.mDirectLibraries.add(testedConfig.mOutput);
        }
    }

    @NonNull
    public String getFullName() {
        if (this.mFullName == null) {
            StringBuilder sb = new StringBuilder();
            String flavorName = this.getFlavorName();
            if (!flavorName.isEmpty()) {
                sb.append(flavorName);
                sb.append(StringHelper.capitalize(this.mBuildType.getName()));
            } else {
                sb.append(this.mBuildType.getName());
            }
            if (this.mType == Type.TEST) {
                sb.append("Test");
            }
            this.mFullName = sb.toString();
        }
        return this.mFullName;
    }

    @NonNull
    public String getFlavorName() {
        if (this.mFlavorName == null) {
            if (this.mFlavorConfigs.isEmpty()) {
                this.mFlavorName = "";
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
                    sb.append(first ? flavor.getName() : StringHelper.capitalize(flavor.getName()));
                    first = false;
                }
                this.mFlavorName = sb.toString();
            }
        }
        return this.mFlavorName;
    }

    @NonNull
    public String getBaseName() {
        if (this.mBaseName == null) {
            StringBuilder sb = new StringBuilder();
            if (!this.mFlavorConfigs.isEmpty()) {
                for (DefaultProductFlavor pf : this.mFlavorConfigs) {
                    sb.append(pf.getName()).append('-');
                }
            }
            sb.append(this.mBuildType.getName());
            if (this.mType == Type.TEST) {
                sb.append('-').append("test");
            }
            this.mBaseName = sb.toString();
        }
        return this.mBaseName;
    }

    @NonNull
    public String getDirName() {
        if (this.mDirName == null) {
            StringBuilder sb = new StringBuilder();
            if (this.mType == Type.TEST) {
                sb.append("test/");
            }
            if (!this.mFlavorConfigs.isEmpty()) {
                for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
                    sb.append(flavor.getName());
                }
                sb.append('/').append(this.mBuildType.getName());
            } else {
                sb.append(this.mBuildType.getName());
            }
            this.mDirName = sb.toString();
        }
        return this.mDirName;
    }

    @NonNull
    public List<String> getFlavorNamesWithDimensionNames() {
        List<Object> names;
        if (this.mFlavorConfigs.isEmpty()) {
            return Collections.emptyList();
        }
        int count = this.mFlavorConfigs.size();
        if (count > 1) {
            names = Lists.newArrayListWithCapacity((int)(count * 2));
            for (int i = 0; i < count; ++i) {
                names.add(this.mFlavorConfigs.get(i).getName());
                names.add(this.mFlavorDimensionNames.get(i));
            }
        } else {
            names = Collections.singletonList(this.mFlavorConfigs.get(0).getName());
        }
        return names;
    }

    @NonNull
    public VariantConfiguration addProductFlavor(@NonNull DefaultProductFlavor productFlavor, @NonNull SourceProvider sourceProvider, @NonNull String dimensionName) {
        this.mFlavorConfigs.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mFlavorDimensionNames.add(dimensionName);
        this.mMergedFlavor = productFlavor.mergeOver(this.mMergedFlavor);
        this.computeNdkConfig();
        return this;
    }

    public void checkSourceProviders() {
        ArrayList providers = Lists.newArrayListWithExpectedSize((int)(4 + this.mFlavorSourceProviders.size()));
        providers.add(this.mDefaultSourceProvider);
        if (this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        providers.addAll(this.mFlavorSourceProviders);
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        try {
            VariantConfiguration.checkFileSourceSet(providers, SourceProvider.class.getMethod("getManifestFile", new Class[0]), "manifest");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getJavaDirectories", new Class[0]), "java");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getResourcesDirectories", new Class[0]), "resources");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getAidlDirectories", new Class[0]), "aidl");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getRenderscriptDirectories", new Class[0]), "rs");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getJniDirectories", new Class[0]), "jni");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getResDirectories", new Class[0]), "res");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getAssetsDirectories", new Class[0]), "assets");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getJniLibsDirectories", new Class[0]), "jniLibs");
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void checkFileSourceSet(List<SourceProvider> providers, Method m, @NonNull String name) throws IllegalAccessException, InvocationTargetException {
        HashMap map = Maps.newHashMap();
        for (SourceProvider sourceProvider : providers) {
            File file = (File)m.invoke((Object)sourceProvider, new Object[0]);
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!file.equals(entry.getValue())) continue;
                    throw new RuntimeException(String.format("SourceSets '%s' and '%s' use the same file for '%s': %s", sourceProvider.getName(), entry.getKey(), name, file));
                }
            }
            map.put(sourceProvider.getName(), file);
        }
    }

    private static void checkFileCollectionSourceSet(List<SourceProvider> providers, Method m, @NonNull String name) throws IllegalAccessException, InvocationTargetException {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (SourceProvider sourceProvider : providers) {
            Collection list = (Collection)m.invoke((Object)sourceProvider, new Object[0]);
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.asMap().entrySet()) {
                    Collection existingFiles = (Collection)entry.getValue();
                    for (File f : list) {
                        if (!existingFiles.contains(f)) continue;
                        throw new RuntimeException(String.format("SourceSets '%s' and '%s' use the same file/folder for '%s': %s", sourceProvider.getName(), entry.getKey(), name, f));
                    }
                }
            }
            map.putAll((Object)sourceProvider.getName(), (Iterable)list);
        }
    }

    public VariantConfiguration setVariantSourceProvider(@Nullable SourceProvider sourceProvider) {
        this.mVariantSourceProvider = sourceProvider;
        return this;
    }

    public VariantConfiguration setMultiFlavorSourceProvider(@Nullable SourceProvider sourceProvider) {
        this.mMultiFlavorSourceProvider = sourceProvider;
        return this;
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        return this.mVariantSourceProvider;
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        return this.mMultiFlavorSourceProvider;
    }

    private void computeNdkConfig() {
        this.mMergedNdkConfig.reset();
        if (this.mDefaultConfig.getNdkConfig() != null) {
            this.mMergedNdkConfig.append(this.mDefaultConfig.getNdkConfig());
        }
        for (int i = this.mFlavorConfigs.size() - 1; i >= 0; --i) {
            NdkConfig ndkConfig = this.mFlavorConfigs.get(i).getNdkConfig();
            if (ndkConfig == null) continue;
            this.mMergedNdkConfig.append(ndkConfig);
        }
        if (this.mBuildType.getNdkConfig() != null && this.mType != Type.TEST) {
            this.mMergedNdkConfig.append(this.mBuildType.getNdkConfig());
        }
    }

    @NonNull
    public VariantConfiguration setDependencies(@NonNull DependencyContainer container) {
        this.mDirectLibraries.addAll(container.getAndroidDependencies());
        this.mJars.addAll(container.getJarDependencies());
        this.mJars.addAll(container.getLocalDependencies());
        this.resolveIndirectLibraryDependencies(this.mDirectLibraries, this.mFlatLibraries);
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            this.mJars.addAll(libraryDependency.getLocalDependencies());
        }
        return this;
    }

    @NonNull
    public Collection<JarDependency> getJars() {
        return this.mJars;
    }

    @NonNull
    public VariantConfiguration setOutput(LibraryDependency output) {
        this.mOutput = output;
        return this;
    }

    @NonNull
    public DefaultProductFlavor getDefaultConfig() {
        return this.mDefaultConfig;
    }

    @NonNull
    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    @NonNull
    public DefaultBuildType getBuildType() {
        return this.mBuildType;
    }

    @Nullable
    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavorConfigs.isEmpty();
    }

    @NonNull
    public List<DefaultProductFlavor> getFlavorConfigs() {
        return this.mFlavorConfigs;
    }

    @NonNull
    public List<SourceProvider> getFlavorSourceProviders() {
        return this.mFlavorSourceProviders;
    }

    public boolean hasLibraries() {
        return !this.mDirectLibraries.isEmpty();
    }

    @NonNull
    public List<LibraryDependency> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    @NonNull
    public List<LibraryDependency> getAllLibraries() {
        return this.mFlatLibraries;
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Nullable
    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    void resolveIndirectLibraryDependencies(List<LibraryDependency> directDependencies, List<LibraryDependency> outFlatDependencies) {
        if (directDependencies == null) {
            return;
        }
        for (int i = directDependencies.size() - 1; i >= 0; --i) {
            LibraryDependency library = directDependencies.get(i);
            List<LibraryDependency> dependencies = library.getDependencies();
            ArrayList depList = Lists.newArrayList(dependencies);
            this.resolveIndirectLibraryDependencies(depList, outFlatDependencies);
            if (outFlatDependencies.contains(library)) continue;
            outFlatDependencies.add(0, library);
        }
    }

    @Nullable
    public String getOriginalPackageName() {
        if (this.mType == Type.TEST) {
            return this.getPackageName();
        }
        return this.getPackageFromManifest();
    }

    @Override
    @NonNull
    public String getPackageName() {
        String packageName;
        if (this.mType == Type.TEST) {
            assert (this.mTestedConfig != null);
            packageName = this.mMergedFlavor.getTestPackageName();
            if (packageName == null) {
                String testedPackage = this.mTestedConfig.getPackageName();
                packageName = testedPackage + ".test";
            }
        } else {
            packageName = this.getPackageOverride();
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
        }
        if (packageName == null) {
            throw new RuntimeException("Failed get query package name for " + this.getFullName());
        }
        return packageName;
    }

    @Override
    @Nullable
    public String getTestedPackageName() {
        if (this.mType == Type.TEST) {
            assert (this.mTestedConfig != null);
            if (this.mTestedConfig.mType == Type.LIBRARY) {
                return this.getPackageName();
            }
            return this.mTestedConfig.getPackageName();
        }
        return null;
    }

    @Nullable
    public String getPackageOverride() {
        String packageName = this.mMergedFlavor.getPackageName();
        String packageSuffix = this.mBuildType.getPackageNameSuffix();
        if (packageSuffix != null && !packageSuffix.isEmpty()) {
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
            packageName = packageSuffix.charAt(0) == '.' ? packageName + packageSuffix : packageName + '.' + packageSuffix;
        }
        return packageName;
    }

    @Nullable
    public String getVersionName() {
        String versionName = this.mMergedFlavor.getVersionName();
        String versionSuffix = this.mBuildType.getVersionNameSuffix();
        if (versionSuffix != null && !versionSuffix.isEmpty()) {
            if (versionName == null) {
                versionName = this.mType != Type.TEST ? this.getVersionNameFromManifest() : "";
            }
            versionName = versionName + versionSuffix;
        }
        return versionName;
    }

    public int getVersionCode() {
        int versionCode = this.mMergedFlavor.getVersionCode();
        if (versionCode == -1 && this.mType != Type.TEST) {
            versionCode = this.getVersionCodeFromManifest();
        }
        return versionCode;
    }

    @Override
    @NonNull
    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (runner = config.mMergedFlavor.getTestInstrumentationRunner()) != null ? runner : DEFAULT_TEST_RUNNER;
    }

    @Override
    @NonNull
    public Boolean getHandleProfiling() {
        Boolean handleProfiling;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (handleProfiling = config.mMergedFlavor.getTestHandleProfiling()) != null ? handleProfiling : DEFAULT_HANDLE_PROFILING;
    }

    @Override
    @NonNull
    public Boolean getFunctionalTest() {
        Boolean functionalTest;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (functionalTest = config.mMergedFlavor.getTestFunctionalTest()) != null ? functionalTest : DEFAULT_FUNCTIONAL_TEST;
    }

    @Nullable
    public String getPackageFromManifest() {
        assert (this.mType != Type.TEST);
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getPackage(manifestLocation);
    }

    @Nullable
    public String getVersionNameFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getVersionName(manifestLocation);
    }

    public int getVersionCodeFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getVersionCode(manifestLocation);
    }

    @Override
    public int getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        int minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == -1) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            minSdkVersion = sManifestParser.getMinSdkVersion(manifestLocation);
        }
        return minSdkVersion;
    }

    public int getTargetSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getTargetSdkVersion();
        }
        int targetSdkVersion = this.mMergedFlavor.getTargetSdkVersion();
        if (targetSdkVersion == -1) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            targetSdkVersion = sManifestParser.getTargetSdkVersion(manifestLocation);
        }
        return targetSdkVersion;
    }

    @Nullable
    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    @NonNull
    public List<SourceProvider> getSortedSourceProviders() {
        ArrayList providers = Lists.newArrayList();
        providers.add(this.mDefaultSourceProvider);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            providers.add(this.mFlavorSourceProviders.get(n));
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        if (this.mType != Type.TEST && this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        return providers;
    }

    @NonNull
    public List<BaseConfig> getSortedBaseConfigs() {
        ArrayList configs = Lists.newArrayList();
        configs.add(this.mDefaultConfig);
        for (int n = this.mFlavorConfigs.size() - 1; n >= 0; --n) {
            configs.add(this.mFlavorConfigs.get(n));
        }
        if (this.mType != Type.TEST) {
            configs.add(this.mBuildType);
        }
        return configs;
    }

    @NonNull
    public List<File> getManifestOverlays() {
        File typeLocation;
        File variantLocation;
        ArrayList inputs = Lists.newArrayList();
        if (this.mVariantSourceProvider != null && (variantLocation = this.mVariantSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()).isFile()) {
            inputs.add(typeLocation);
        }
        if (this.mMultiFlavorSourceProvider != null && (variantLocation = this.mMultiFlavorSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (!f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    @NonNull
    public List<ResourceSet> getResourceSets(@NonNull List<File> generatedResFolders, boolean includeDependencies) {
        ArrayList resourceSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                File resFolder = dependency.getResFolder();
                if (!resFolder.isDirectory()) continue;
                ResourceSet resourceSet = new ResourceSet(dependency.getFolder().getName());
                resourceSet.addSource(resFolder);
                resourceSets.add(resourceSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getResDirectories();
        ResourceSet resourceSet = new ResourceSet("main");
        resourceSet.addSources(mainResDirs);
        if (!generatedResFolders.isEmpty()) {
            for (File generatedResFolder : generatedResFolders) {
                resourceSet.addSource(generatedResFolder);
            }
        }
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getResDirectories();
            resourceSet = new ResourceSet(sourceProvider.getName());
            resourceSet.addSources(flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFlavorName());
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName());
            resourceSet.addSources(typeResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFullName());
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    @NonNull
    public List<AssetSet> getAssetSets(boolean includeDependencies) {
        ArrayList assetSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                File assetFolder = dependency.getAssetsFolder();
                if (!assetFolder.isDirectory()) continue;
                AssetSet assetSet = new AssetSet(dependency.getFolder().getName());
                assetSet.addSource(assetFolder);
                assetSets.add(assetSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getAssetsDirectories();
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources(mainResDirs);
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mFlavorConfigs.get(n).getName());
            assetSet.addSources(flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFlavorName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources(typeResDirs);
            assetSets.add(assetSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFullName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    @NonNull
    public List<File> getLibraryJniFolders() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.mFlatLibraries.size());
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            LibraryDependency dependency = this.mFlatLibraries.get(n);
            File jniFolder = dependency.getJniFolder();
            if (!jniFolder.isDirectory()) continue;
            list.add(jniFolder);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File rsLib = lib.getRenderscriptFolder();
            if (!rsLib.isDirectory()) continue;
            list.add(rsLib);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getRenderscriptDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getAidlImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File aidlLib = lib.getAidlFolder();
            if (!aidlLib.isDirectory()) continue;
            list.add(aidlLib);
        }
        return list;
    }

    @NonNull
    public List<File> getAidlSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getAidlDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getJniSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getJniDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getJniLibsList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getJniLibsDirectories());
        }
        return sourceList;
    }

    @NonNull
    public Set<File> getCompileClasspath() {
        HashSet classpath = Sets.newHashSetWithExpectedSize((int)(this.mJars.size() + this.mFlatLibraries.size()));
        for (LibraryDependency lib : this.mFlatLibraries) {
            classpath.add(lib.getJarFile());
            for (File jarFile : lib.getLocalJars()) {
                classpath.add(jarFile);
            }
        }
        for (JarDependency jar : this.mJars) {
            if (!jar.isCompiled()) continue;
            classpath.add(jar.getJarFile());
        }
        return classpath;
    }

    @NonNull
    public Set<File> getPackagedJars() {
        HashSet jars = Sets.newHashSetWithExpectedSize((int)(this.mJars.size() + this.mFlatLibraries.size()));
        for (JarDependency jar : this.mJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add(libJar);
            }
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add(jarFile);
            }
        }
        return jars;
    }

    @NonNull
    public List<File> getProvidedOnlyJars() {
        HashSet jars = Sets.newHashSetWithExpectedSize((int)this.mJars.size());
        for (JarDependency jar : this.mJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isCompiled() || jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        return Lists.newArrayList((Iterable)jars);
    }

    @NonNull
    public List<Object> getBuildConfigItems() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<ClassField> list = this.mBuildType.getBuildConfigFields().values();
        if (!list.isEmpty()) {
            fullList.add("Fields from build type: " + this.mBuildType.getName());
            for (ClassField f : list) {
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            list = flavor.getBuildConfigFields().values();
            if (list.isEmpty()) continue;
            fullList.add("Fields from product flavor: " + flavor.getName());
            for (ClassField f : list) {
                String name = f.getName();
                if (usedFieldNames.contains(name)) continue;
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        list = this.mDefaultConfig.getBuildConfigFields().values();
        if (!list.isEmpty()) {
            fullList.add("Fields from default config.");
            for (ClassField f : list) {
                String name = f.getName();
                if (usedFieldNames.contains(name)) continue;
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        return fullList;
    }

    @NonNull
    public List<Object> getResValues() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<ClassField> list = this.mBuildType.getResValues().values();
        if (!list.isEmpty()) {
            fullList.add("Values from build type: " + this.mBuildType.getName());
            for (ClassField f : list) {
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            list = flavor.getResValues().values();
            if (list.isEmpty()) continue;
            fullList.add("Values from product flavor: " + flavor.getName());
            for (ClassField f : list) {
                String name = f.getName();
                if (usedFieldNames.contains(name)) continue;
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        list = this.mDefaultConfig.getResValues().values();
        if (!list.isEmpty()) {
            fullList.add("Values from default config.");
            for (ClassField f : list) {
                String name = f.getName();
                if (usedFieldNames.contains(name)) continue;
                usedFieldNames.add(f.getName());
                fullList.add(f);
            }
        }
        return fullList;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    @NonNull
    public List<Object> getProguardFiles(boolean includeLibraries) {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getProguardFiles());
        fullList.addAll(this.mBuildType.getProguardFiles());
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            fullList.addAll(flavor.getProguardFiles());
        }
        if (includeLibraries) {
            for (LibraryDependency libraryDependency : this.mFlatLibraries) {
                File proguardRules = libraryDependency.getProguardRules();
                if (!proguardRules.exists()) continue;
                fullList.add(proguardRules);
            }
        }
        return fullList;
    }

    @NonNull
    public List<Object> getConsumerProguardFiles() {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getConsumerProguardFiles());
        fullList.addAll(this.mBuildType.getConsumerProguardFiles());
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            fullList.addAll(flavor.getConsumerProguardFiles());
        }
        return fullList;
    }

    @NonNull
    public NdkConfig getNdkConfig() {
        return this.mMergedNdkConfig;
    }

    @Override
    @Nullable
    public Set<String> getSupportedAbis() {
        if (this.mMergedNdkConfig != null) {
            return this.mMergedNdkConfig.getAbiFilters();
        }
        return null;
    }

    public static enum Type {
        DEFAULT,
        LIBRARY,
        TEST;

    }
}

