/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DefaultApiVersion;
import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.ManifestParser;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.internal.StringHelper;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.ClassField;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.ResourceSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantConfiguration<T extends BuildType, D extends ProductFlavor, F extends ProductFlavor> {
    private final ManifestParser sManifestParser = new DefaultManifestParser();
    private String mFullName;
    private String mFlavorName;
    private String mBaseName;
    private String mDirName;
    @NonNull
    private final D mDefaultConfig;
    @NonNull
    private final SourceProvider mDefaultSourceProvider;
    @NonNull
    private final T mBuildType;
    @Nullable
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<String> mFlavorDimensionNames = Lists.newArrayList();
    private final List<F> mFlavors = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    @Nullable
    private SourceProvider mVariantSourceProvider;
    @Nullable
    private SourceProvider mMultiFlavorSourceProvider;
    @NonNull
    private final Type mType;
    private final VariantConfiguration mTestedConfig;
    private LibraryDependency mOutput;
    @NonNull
    private ProductFlavor mMergedFlavor;
    private final Set<JarDependency> mJars = Sets.newHashSet();
    private final List<LibraryDependency> mDirectLibraries = Lists.newArrayList();
    private final List<LibraryDependency> mFlatLibraries = Lists.newArrayList();
    private final Map<String, ClassField> mBuildConfigFields = Maps.newTreeMap();
    private final Map<String, ClassField> mResValues = Maps.newTreeMap();
    private final SigningConfig mSigningConfigOverride;
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";
    private static final Boolean DEFAULT_HANDLE_PROFILING = false;
    private static final Boolean DEFAULT_FUNCTIONAL_TEST = false;

    @Nullable
    public static String getManifestPackage(@NonNull File manifestFile) {
        return new DefaultManifestParser().getPackage(manifestFile);
    }

    public VariantConfiguration(@NonNull D defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull T buildType, @Nullable SourceProvider buildTypeSourceProvider, @Nullable SigningConfig signingConfigOverride) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, Type.DEFAULT, null, signingConfigOverride);
    }

    public VariantConfiguration(@NonNull D defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull T buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable SigningConfig signingConfigOverride) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, null, signingConfigOverride);
    }

    public VariantConfiguration(@NonNull D defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull T buildType, @Nullable SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable VariantConfiguration testedConfig, @Nullable SigningConfig signingConfigOverride) {
        this.mDefaultConfig = (ProductFlavor)Preconditions.checkNotNull(defaultConfig);
        this.mDefaultSourceProvider = (SourceProvider)Preconditions.checkNotNull((Object)defaultSourceProvider);
        this.mBuildType = (BuildType)Preconditions.checkNotNull(buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mTestedConfig = testedConfig;
        this.mSigningConfigOverride = signingConfigOverride;
        Preconditions.checkState((this.mType != Type.TEST || this.mTestedConfig != null ? 1 : 0) != 0);
        this.mMergedFlavor = DefaultProductFlavor.clone(this.mDefaultConfig);
    }

    @NonNull
    public String getFullName() {
        if (this.mFullName == null) {
            StringBuilder sb = new StringBuilder();
            String flavorName = this.getFlavorName();
            if (!flavorName.isEmpty()) {
                sb.append(flavorName);
                sb.append(StringHelper.capitalize(this.mBuildType.getName()));
            } else {
                sb.append(this.mBuildType.getName());
            }
            if (this.mType == Type.TEST) {
                sb.append("Test");
            }
            this.mFullName = sb.toString();
        }
        return this.mFullName;
    }

    @NonNull
    public String computeFullNameWithSplits(@NonNull String splitName) {
        StringBuilder sb = new StringBuilder();
        String flavorName = this.getFlavorName();
        if (!flavorName.isEmpty()) {
            sb.append(flavorName);
            sb.append(StringHelper.capitalize(splitName));
        } else {
            sb.append(splitName);
        }
        sb.append(StringHelper.capitalize(this.mBuildType.getName()));
        if (this.mType == Type.TEST) {
            sb.append("Test");
        }
        return sb.toString();
    }

    @NonNull
    public String getFlavorName() {
        if (this.mFlavorName == null) {
            if (this.mFlavors.isEmpty()) {
                this.mFlavorName = "";
            } else {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (ProductFlavor flavor : this.mFlavors) {
                    sb.append(first ? flavor.getName() : StringHelper.capitalize(flavor.getName()));
                    first = false;
                }
                this.mFlavorName = sb.toString();
            }
        }
        return this.mFlavorName;
    }

    @NonNull
    public String getBaseName() {
        if (this.mBaseName == null) {
            StringBuilder sb = new StringBuilder();
            if (!this.mFlavors.isEmpty()) {
                for (ProductFlavor pf : this.mFlavors) {
                    sb.append(pf.getName()).append('-');
                }
            }
            sb.append(this.mBuildType.getName());
            if (this.mType == Type.TEST) {
                sb.append('-').append("test");
            }
            this.mBaseName = sb.toString();
        }
        return this.mBaseName;
    }

    @NonNull
    public String computeBaseNameWithSplits(@NonNull String splitName) {
        StringBuilder sb = new StringBuilder();
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor pf : this.mFlavors) {
                sb.append(pf.getName()).append('-');
            }
        }
        sb.append(splitName).append('-');
        sb.append(this.mBuildType.getName());
        if (this.mType == Type.TEST) {
            sb.append('-').append("test");
        }
        return sb.toString();
    }

    @NonNull
    public String getDirName() {
        if (this.mDirName == null) {
            StringBuilder sb = new StringBuilder();
            if (this.mType == Type.TEST) {
                sb.append("test/");
            }
            if (!this.mFlavors.isEmpty()) {
                for (ProductFlavor flavor : this.mFlavors) {
                    sb.append(flavor.getName());
                }
                sb.append('/').append(this.mBuildType.getName());
            } else {
                sb.append(this.mBuildType.getName());
            }
            this.mDirName = sb.toString();
        }
        return this.mDirName;
    }

    @NonNull
    public String computeDirNameWithSplits(String ... splitNames) {
        StringBuilder sb = new StringBuilder();
        if (this.mType == Type.TEST) {
            sb.append("test/");
        }
        if (!this.mFlavors.isEmpty()) {
            for (ProductFlavor flavor : this.mFlavors) {
                sb.append(flavor.getName());
            }
            sb.append('/');
        }
        for (String splitName : splitNames) {
            if (splitName == null) continue;
            sb.append(splitName).append('/');
        }
        sb.append(this.mBuildType.getName());
        return sb.toString();
    }

    @NonNull
    public List<String> getFlavorNamesWithDimensionNames() {
        List<Object> names;
        if (this.mFlavors.isEmpty()) {
            return Collections.emptyList();
        }
        int count = this.mFlavors.size();
        if (count > 1) {
            names = Lists.newArrayListWithCapacity((int)(count * 2));
            for (int i = 0; i < count; ++i) {
                names.add(((ProductFlavor)this.mFlavors.get(i)).getName());
                names.add(this.mFlavorDimensionNames.get(i));
            }
        } else {
            names = Collections.singletonList(((ProductFlavor)this.mFlavors.get(0)).getName());
        }
        return names;
    }

    @NonNull
    public VariantConfiguration addProductFlavor(@NonNull F productFlavor, @NonNull SourceProvider sourceProvider, @NonNull String dimensionName) {
        this.mFlavors.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mFlavorDimensionNames.add(dimensionName);
        this.mMergedFlavor = DefaultProductFlavor.mergeFlavors(this.mMergedFlavor, productFlavor);
        return this;
    }

    public void checkSourceProviders() {
        ArrayList providers = Lists.newArrayListWithExpectedSize((int)(4 + this.mFlavorSourceProviders.size()));
        providers.add(this.mDefaultSourceProvider);
        if (this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        providers.addAll(this.mFlavorSourceProviders);
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        try {
            VariantConfiguration.checkFileSourceSet(providers, SourceProvider.class.getMethod("getManifestFile", new Class[0]), "manifest");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getJavaDirectories", new Class[0]), "java");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getResourcesDirectories", new Class[0]), "resources");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getAidlDirectories", new Class[0]), "aidl");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getRenderscriptDirectories", new Class[0]), "rs");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getCDirectories", new Class[0]), "c");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getCppDirectories", new Class[0]), "cpp");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getResDirectories", new Class[0]), "res");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getAssetsDirectories", new Class[0]), "assets");
            VariantConfiguration.checkFileCollectionSourceSet(providers, SourceProvider.class.getMethod("getJniLibsDirectories", new Class[0]), "jniLibs");
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (InvocationTargetException ignored) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void checkFileSourceSet(List<SourceProvider> providers, Method m, @NonNull String name) throws IllegalAccessException, InvocationTargetException {
        HashMap map = Maps.newHashMap();
        for (SourceProvider sourceProvider : providers) {
            File file = (File)m.invoke((Object)sourceProvider, new Object[0]);
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!file.equals(entry.getValue())) continue;
                    throw new RuntimeException(String.format("SourceSets '%s' and '%s' use the same file for '%s': %s", sourceProvider.getName(), entry.getKey(), name, file));
                }
            }
            map.put(sourceProvider.getName(), file);
        }
    }

    private static void checkFileCollectionSourceSet(List<SourceProvider> providers, Method m, @NonNull String name) throws IllegalAccessException, InvocationTargetException {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (SourceProvider sourceProvider : providers) {
            Collection list = (Collection)m.invoke((Object)sourceProvider, new Object[0]);
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.asMap().entrySet()) {
                    Collection existingFiles = (Collection)entry.getValue();
                    for (File f : list) {
                        if (!existingFiles.contains(f)) continue;
                        throw new RuntimeException(String.format("SourceSets '%s' and '%s' use the same file/folder for '%s': %s", sourceProvider.getName(), entry.getKey(), name, f));
                    }
                }
            }
            map.putAll((Object)sourceProvider.getName(), (Iterable)list);
        }
    }

    public VariantConfiguration setVariantSourceProvider(@Nullable SourceProvider sourceProvider) {
        this.mVariantSourceProvider = sourceProvider;
        return this;
    }

    public VariantConfiguration setMultiFlavorSourceProvider(@Nullable SourceProvider sourceProvider) {
        this.mMultiFlavorSourceProvider = sourceProvider;
        return this;
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        return this.mVariantSourceProvider;
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        return this.mMultiFlavorSourceProvider;
    }

    @NonNull
    public VariantConfiguration setDependencies(@NonNull DependencyContainer container) {
        if (this.mTestedConfig != null && this.mTestedConfig.mType == Type.LIBRARY && this.mTestedConfig.mOutput != null && !this.mDirectLibraries.contains(this.mTestedConfig.mOutput)) {
            this.mDirectLibraries.add(this.mTestedConfig.mOutput);
        }
        this.mDirectLibraries.addAll(container.getAndroidDependencies());
        this.mJars.addAll(container.getJarDependencies());
        this.mJars.addAll(container.getLocalDependencies());
        this.resolveIndirectLibraryDependencies(this.mDirectLibraries, this.mFlatLibraries);
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            this.mJars.addAll(libraryDependency.getLocalDependencies());
        }
        return this;
    }

    @NonNull
    public Collection<JarDependency> getJars() {
        return this.mJars;
    }

    @NonNull
    public VariantConfiguration setOutput(LibraryDependency output) {
        this.mOutput = output;
        return this;
    }

    @NonNull
    public D getDefaultConfig() {
        return this.mDefaultConfig;
    }

    @NonNull
    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    @NonNull
    public ProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    @NonNull
    public T getBuildType() {
        return this.mBuildType;
    }

    @Nullable
    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavors.isEmpty();
    }

    @NonNull
    public List<F> getProductFlavors() {
        return this.mFlavors;
    }

    @NonNull
    public List<SourceProvider> getFlavorSourceProviders() {
        return this.mFlavorSourceProviders;
    }

    public boolean hasLibraries() {
        return !this.mDirectLibraries.isEmpty();
    }

    @NonNull
    public List<LibraryDependency> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    @NonNull
    public List<LibraryDependency> getAllLibraries() {
        return this.mFlatLibraries;
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Nullable
    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    void resolveIndirectLibraryDependencies(List<LibraryDependency> directDependencies, List<LibraryDependency> outFlatDependencies) {
        if (directDependencies == null) {
            return;
        }
        for (int i = directDependencies.size() - 1; i >= 0; --i) {
            LibraryDependency library = directDependencies.get(i);
            List<LibraryDependency> dependencies = library.getDependencies();
            ArrayList depList = Lists.newArrayList(dependencies);
            this.resolveIndirectLibraryDependencies(depList, outFlatDependencies);
            if (outFlatDependencies.contains(library)) continue;
            outFlatDependencies.add(0, library);
        }
    }

    @Nullable
    public String getOriginalApplicationId() {
        if (this.mType == Type.TEST) {
            return this.getApplicationId();
        }
        return this.getPackageFromManifest();
    }

    @NonNull
    public String getApplicationId() {
        String id;
        if (this.mType == Type.TEST) {
            assert (this.mTestedConfig != null);
            id = this.mMergedFlavor.getTestApplicationId();
            if (id == null) {
                String testedPackage = this.mTestedConfig.getApplicationId();
                id = testedPackage + ".test";
            }
        } else {
            id = this.getIdOverride();
            if (id == null) {
                id = this.getPackageFromManifest();
            }
        }
        if (id == null) {
            throw new RuntimeException("Failed to get application id for " + this.getFullName());
        }
        return id;
    }

    @Nullable
    public String getTestedApplicationId() {
        if (this.mType == Type.TEST) {
            assert (this.mTestedConfig != null);
            if (this.mTestedConfig.mType == Type.LIBRARY) {
                return this.getApplicationId();
            }
            return this.mTestedConfig.getApplicationId();
        }
        return null;
    }

    @Nullable
    public String getIdOverride() {
        String idName = this.mMergedFlavor.getApplicationId();
        String idSuffix = this.mBuildType.getApplicationIdSuffix();
        if (idSuffix != null && !idSuffix.isEmpty()) {
            if (idName == null) {
                idName = this.getPackageFromManifest();
            }
            idName = idSuffix.charAt(0) == '.' ? idName + idSuffix : idName + '.' + idSuffix;
        }
        return idName;
    }

    @Nullable
    public String getVersionName() {
        String versionName = this.mMergedFlavor.getVersionName();
        String versionSuffix = this.mBuildType.getVersionNameSuffix();
        if (versionSuffix != null && !versionSuffix.isEmpty()) {
            if (versionName == null) {
                versionName = this.mType != Type.TEST ? this.getVersionNameFromManifest() : "";
            }
            versionName = versionName + versionSuffix;
        }
        return versionName;
    }

    public int getVersionCode() {
        int versionCode;
        int n = versionCode = this.mMergedFlavor.getVersionCode() != null ? this.mMergedFlavor.getVersionCode() : -1;
        if (versionCode == -1 && this.mType != Type.TEST) {
            versionCode = this.getVersionCodeFromManifest();
        }
        return versionCode;
    }

    @NonNull
    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (runner = config.mMergedFlavor.getTestInstrumentationRunner()) != null ? runner : DEFAULT_TEST_RUNNER;
    }

    @NonNull
    public Boolean getHandleProfiling() {
        Boolean handleProfiling;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (handleProfiling = config.mMergedFlavor.getTestHandleProfiling()) != null ? handleProfiling : DEFAULT_HANDLE_PROFILING;
    }

    @NonNull
    public Boolean getFunctionalTest() {
        Boolean functionalTest;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (functionalTest = config.mMergedFlavor.getTestFunctionalTest()) != null ? functionalTest : DEFAULT_FUNCTIONAL_TEST;
    }

    @Nullable
    public String getPackageFromManifest() {
        assert (this.mType != Type.TEST);
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        String packageName = this.sManifestParser.getPackage(manifestLocation);
        if (packageName == null) {
            throw new RuntimeException(String.format("Cannot read packageName from %1$s", this.mDefaultSourceProvider.getManifestFile().getAbsolutePath()));
        }
        return packageName;
    }

    @Nullable
    public String getVersionNameFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return this.sManifestParser.getVersionName(manifestLocation);
    }

    public int getVersionCodeFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return this.sManifestParser.getVersionCode(manifestLocation);
    }

    @NonNull
    public ApiVersion getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        ApiVersion minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == null) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            minSdkVersion = DefaultApiVersion.create(this.sManifestParser.getMinSdkVersion(manifestLocation));
        }
        return minSdkVersion;
    }

    @NonNull
    public ApiVersion getTargetSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getTargetSdkVersion();
        }
        ApiVersion targetSdkVersion = this.mMergedFlavor.getTargetSdkVersion();
        if (targetSdkVersion == null) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            targetSdkVersion = DefaultApiVersion.create(this.sManifestParser.getTargetSdkVersion(manifestLocation));
        }
        return targetSdkVersion;
    }

    @Nullable
    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    @NonNull
    public List<SourceProvider> getSortedSourceProviders() {
        ArrayList providers = Lists.newArrayList();
        providers.add(this.mDefaultSourceProvider);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            providers.add(this.mFlavorSourceProviders.get(n));
        }
        if (this.mMultiFlavorSourceProvider != null) {
            providers.add(this.mMultiFlavorSourceProvider);
        }
        if (this.mType != Type.TEST && this.mBuildTypeSourceProvider != null) {
            providers.add(this.mBuildTypeSourceProvider);
        }
        if (this.mVariantSourceProvider != null) {
            providers.add(this.mVariantSourceProvider);
        }
        return providers;
    }

    @NonNull
    public List<BaseConfig> getSortedBaseConfigs() {
        ArrayList configs = Lists.newArrayList();
        configs.add(this.mDefaultConfig);
        for (int n = this.mFlavors.size() - 1; n >= 0; --n) {
            configs.add(this.mFlavors.get(n));
        }
        if (this.mType != Type.TEST) {
            configs.add(this.mBuildType);
        }
        return configs;
    }

    @NonNull
    public List<File> getManifestOverlays() {
        File typeLocation;
        File variantLocation;
        ArrayList inputs = Lists.newArrayList();
        if (this.mVariantSourceProvider != null && (variantLocation = this.mVariantSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()).isFile()) {
            inputs.add(typeLocation);
        }
        if (this.mMultiFlavorSourceProvider != null && (variantLocation = this.mMultiFlavorSourceProvider.getManifestFile()).isFile()) {
            inputs.add(variantLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (!f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    @NonNull
    public List<ResourceSet> getResourceSets(@NonNull List<File> generatedResFolders, boolean includeDependencies) {
        ArrayList resourceSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                File resFolder = dependency.getResFolder();
                if (!resFolder.isDirectory()) continue;
                ResourceSet resourceSet = new ResourceSet(dependency.getFolder().getName());
                resourceSet.addSource(resFolder);
                resourceSets.add(resourceSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getResDirectories();
        ResourceSet resourceSet = new ResourceSet("main");
        resourceSet.addSources(mainResDirs);
        if (!generatedResFolders.isEmpty()) {
            for (File generatedResFolder : generatedResFolders) {
                resourceSet.addSource(generatedResFolder);
            }
        }
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getResDirectories();
            resourceSet = new ResourceSet(sourceProvider.getName());
            resourceSet.addSources(flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFlavorName());
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName());
            resourceSet.addSources(typeResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.getFullName());
            resourceSet.addSources(variantResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    @NonNull
    public List<AssetSet> getAssetSets(@NonNull List<File> generatedResFolders, boolean includeDependencies) {
        ArrayList assetSets = Lists.newArrayList();
        if (includeDependencies) {
            for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
                LibraryDependency dependency = this.mFlatLibraries.get(n);
                File assetFolder = dependency.getAssetsFolder();
                if (!assetFolder.isDirectory()) continue;
                AssetSet assetSet = new AssetSet(dependency.getFolder().getName());
                assetSet.addSource(assetFolder);
                assetSets.add(assetSet);
            }
        }
        Collection mainResDirs = this.mDefaultSourceProvider.getAssetsDirectories();
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources(mainResDirs);
        if (!generatedResFolders.isEmpty()) {
            for (File generatedResFolder : generatedResFolders) {
                assetSet.addSource(generatedResFolder);
            }
        }
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Collection flavorResDirs = sourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(((ProductFlavor)this.mFlavors.get(n)).getName());
            assetSet.addSources(flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mMultiFlavorSourceProvider != null) {
            Collection variantResDirs = this.mMultiFlavorSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFlavorName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Collection typeResDirs = this.mBuildTypeSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources(typeResDirs);
            assetSets.add(assetSet);
        }
        if (this.mVariantSourceProvider != null) {
            Collection variantResDirs = this.mVariantSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.getFullName());
            assetSet.addSources(variantResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    @NonNull
    public List<File> getLibraryJniFolders() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.mFlatLibraries.size());
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            LibraryDependency dependency = this.mFlatLibraries.get(n);
            File jniFolder = dependency.getJniFolder();
            if (!jniFolder.isDirectory()) continue;
            list.add(jniFolder);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File rsLib = lib.getRenderscriptFolder();
            if (!rsLib.isDirectory()) continue;
            list.add(rsLib);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getRenderscriptDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getAidlImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File aidlLib = lib.getAidlFolder();
            if (!aidlLib.isDirectory()) continue;
            list.add(aidlLib);
        }
        return list;
    }

    @NonNull
    public List<File> getAidlSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getAidlDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getJniSourceList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getCDirectories());
        }
        return sourceList;
    }

    @NonNull
    public List<File> getJniLibsList() {
        List<SourceProvider> providers = this.getSortedSourceProviders();
        ArrayList sourceList = Lists.newArrayListWithExpectedSize((int)providers.size());
        for (SourceProvider provider : providers) {
            sourceList.addAll(provider.getJniLibsDirectories());
        }
        return sourceList;
    }

    @NonNull
    public Set<File> getCompileClasspath() {
        HashSet classpath = Sets.newHashSetWithExpectedSize((int)(this.mJars.size() + this.mFlatLibraries.size()));
        for (LibraryDependency lib : this.mFlatLibraries) {
            classpath.add(lib.getJarFile());
            for (File jarFile : lib.getLocalJars()) {
                classpath.add(jarFile);
            }
        }
        for (JarDependency jar : this.mJars) {
            if (!jar.isCompiled()) continue;
            classpath.add(jar.getJarFile());
        }
        return classpath;
    }

    @NonNull
    public Set<File> getPackagedJars() {
        HashSet jars = Sets.newHashSetWithExpectedSize((int)(this.mJars.size() + this.mFlatLibraries.size()));
        for (JarDependency jar : this.mJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add(libJar);
            }
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add(jarFile);
            }
        }
        return jars;
    }

    @NonNull
    public List<File> getProvidedOnlyJars() {
        HashSet jars = Sets.newHashSetWithExpectedSize((int)this.mJars.size());
        for (JarDependency jar : this.mJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isCompiled() || jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        return Lists.newArrayList((Iterable)jars);
    }

    public void addBuildConfigField(@NonNull String type, @NonNull String name, @NonNull String value) {
        ClassField classField = AndroidBuilder.createClassField(type, name, value);
        this.mBuildConfigFields.put(name, classField);
    }

    public void addResValue(@NonNull String type, @NonNull String name, @NonNull String value) {
        ClassField classField = AndroidBuilder.createClassField(type, name, value);
        this.mResValues.put(name, classField);
    }

    @NonNull
    public List<Object> getBuildConfigItems() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mBuildConfigFields.values();
        if (!list.isEmpty()) {
            fullList.add("Fields from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getBuildConfigFields().values()).isEmpty()) {
            fullList.add("Fields from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getBuildConfigFields().values();
            if (list.isEmpty()) continue;
            fullList.add("Fields from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getBuildConfigFields().values();
        if (!list.isEmpty()) {
            fullList.add("Fields from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    @NonNull
    public Map<String, ClassField> getMergedBuildConfigFields() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getBuildConfigFields());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getBuildConfigFields());
        }
        mergedMap.putAll(this.mBuildType.getBuildConfigFields());
        mergedMap.putAll(this.mBuildConfigFields);
        return mergedMap;
    }

    @NonNull
    public Map<String, ClassField> getMergedResValues() {
        HashMap mergedMap = Maps.newHashMap();
        mergedMap.putAll(this.mDefaultConfig.getResValues());
        for (int i = this.mFlavors.size() - 1; i >= 0; --i) {
            mergedMap.putAll(((ProductFlavor)this.mFlavors.get(i)).getResValues());
        }
        mergedMap.putAll(this.mBuildType.getResValues());
        mergedMap.putAll(this.mResValues);
        return mergedMap;
    }

    private static void fillFieldList(@NonNull List<Object> outList, @NonNull Set<String> usedFieldNames, @NonNull Collection<ClassField> list) {
        for (ClassField f : list) {
            String name = f.getName();
            if (usedFieldNames.contains(name)) continue;
            usedFieldNames.add(f.getName());
            outList.add(f);
        }
    }

    @NonNull
    public List<Object> getResValues() {
        ArrayList fullList = Lists.newArrayList();
        HashSet usedFieldNames = Sets.newHashSet();
        Collection<Object> list = this.mResValues.values();
        if (!list.isEmpty()) {
            fullList.add("Values from the variant");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        if (!(list = this.mBuildType.getResValues().values()).isEmpty()) {
            fullList.add("Values from build type: " + this.mBuildType.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        for (ProductFlavor flavor : this.mFlavors) {
            list = flavor.getResValues().values();
            if (list.isEmpty()) continue;
            fullList.add("Values from product flavor: " + flavor.getName());
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        list = this.mDefaultConfig.getResValues().values();
        if (!list.isEmpty()) {
            fullList.add("Values from default config.");
            VariantConfiguration.fillFieldList(fullList, usedFieldNames, list);
        }
        return fullList;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        if (this.mSigningConfigOverride != null) {
            return this.mSigningConfigOverride;
        }
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    @NonNull
    public List<File> getProguardFiles(boolean includeLibraries, List<File> defaultProguardConfig) {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getProguardFiles());
        fullList.addAll(this.mBuildType.getProguardFiles());
        for (ProductFlavor flavor : this.mFlavors) {
            fullList.addAll(flavor.getProguardFiles());
        }
        if (fullList.isEmpty()) {
            fullList.addAll(defaultProguardConfig);
        }
        if (includeLibraries) {
            for (LibraryDependency libraryDependency : this.mFlatLibraries) {
                File proguardRules = libraryDependency.getProguardRules();
                if (!proguardRules.exists()) continue;
                fullList.add(proguardRules);
            }
        }
        return fullList;
    }

    @NonNull
    public List<Object> getConsumerProguardFiles() {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getConsumerProguardFiles());
        fullList.addAll(this.mBuildType.getConsumerProguardFiles());
        for (ProductFlavor flavor : this.mFlavors) {
            fullList.addAll(flavor.getConsumerProguardFiles());
        }
        return fullList;
    }

    public boolean isTestCoverageEnabled() {
        return this.mBuildType.isTestCoverageEnabled();
    }

    @NonNull
    public Map<String, Object> getManifestPlaceholders() {
        Map mergedFlavorsPlaceholders = this.mMergedFlavor.getManifestPlaceholders();
        mergedFlavorsPlaceholders.putAll(this.mBuildType.getManifestPlaceholders());
        return mergedFlavorsPlaceholders;
    }

    public boolean isMultiDexEnabled() {
        Boolean value = this.mBuildType.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public File getMultiDexKeepFile() {
        File value = this.mBuildType.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepFile();
        if (value != null) {
            return value;
        }
        return null;
    }

    public File getMultiDexKeepProguard() {
        File value = this.mBuildType.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        value = this.mMergedFlavor.getMultiDexKeepProguard();
        if (value != null) {
            return value;
        }
        return null;
    }

    public boolean isLegacyMultiDexMode() {
        return this.isMultiDexEnabled() && this.getMinSdkVersion().getApiLevel() < 21;
    }

    public boolean getRenderscriptSupportModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptSupportModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public boolean getRenderscriptNdkModeEnabled() {
        Boolean value = this.mMergedFlavor.getRenderscriptNdkModeEnabled();
        if (value != null) {
            return value;
        }
        return false;
    }

    public static enum Type {
        DEFAULT,
        LIBRARY,
        TEST;

    }
}

