/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.QueueThreadContext;
import com.android.builder.tasks.Task;
import com.android.builder.tasks.WorkQueue;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.PngCruncher;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueuedCruncher
implements PngCruncher {
    @NonNull
    private final String mAaptLocation;
    @NonNull
    private final ILogger mLogger;
    @NonNull
    private final WorkQueue<AaptProcess> mCrunchingRequests;
    @NonNull
    private final ConcurrentLinkedQueue<Job<AaptProcess>> mOutstandingJobs = new ConcurrentLinkedQueue();

    private QueuedCruncher(@NonNull String aaptLocation, @NonNull ILogger iLogger) {
        this.mAaptLocation = aaptLocation;
        this.mLogger = iLogger;
        QueueThreadContext<AaptProcess> queueThreadContext = new QueueThreadContext<AaptProcess>(){
            @NonNull
            private final Map<String, AaptProcess> mAaptProcesses = new HashMap<String, AaptProcess>();

            @Override
            public void creation(Thread t) throws IOException {
                try {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): create aapt slave", new Object[]{Thread.currentThread().getName()});
                    AaptProcess aaptProcess = new AaptProcess.Builder(QueuedCruncher.this.mAaptLocation, QueuedCruncher.this.mLogger).start();
                    assert (aaptProcess != null);
                    this.mAaptProcesses.put(t.getName(), aaptProcess);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void runTask(Job<AaptProcess> job) throws Exception {
                job.runTask(new JobContext<AaptProcess>(this.mAaptProcesses.get(Thread.currentThread().getName())));
            }

            @Override
            public void destruction(Thread t) throws IOException, InterruptedException {
                AaptProcess aaptProcess = this.mAaptProcesses.get(Thread.currentThread().getName());
                if (aaptProcess != null) {
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): notify aapt slave shutdown", new Object[]{Thread.currentThread().getName()});
                    aaptProcess.shutdown();
                    this.mAaptProcesses.remove(t.getName());
                    QueuedCruncher.this.mLogger.verbose("Thread(%1$s): after shutdown queue_size=%2$d", new Object[]{Thread.currentThread().getName(), this.mAaptProcesses.size()});
                }
            }

            @Override
            public void shutdown() {
                if (!this.mAaptProcesses.isEmpty()) {
                    QueuedCruncher.this.mLogger.warning("Process list not empty", new Object[0]);
                    for (Map.Entry<String, AaptProcess> aaptProcessEntry : this.mAaptProcesses.entrySet()) {
                        QueuedCruncher.this.mLogger.warning("Thread(%1$s): queue not cleaned", new Object[]{aaptProcessEntry.getKey()});
                        try {
                            aaptProcessEntry.getValue().shutdown();
                        }
                        catch (Exception e) {
                            QueuedCruncher.this.mLogger.error((Throwable)e, "while shutting down" + aaptProcessEntry.getKey(), new Object[0]);
                        }
                    }
                }
                this.mAaptProcesses.clear();
            }
        };
        this.mCrunchingRequests = new WorkQueue<AaptProcess>(this.mLogger, queueThreadContext, "png-cruncher", 5, 2);
    }

    public void crunchPng(final @NonNull File from, final @NonNull File to) throws InterruptedException, LoggedErrorException, IOException {
        Job<AaptProcess> aaptProcessJob = new Job<AaptProcess>("Cruncher " + from.getName(), new Task<AaptProcess>(){

            @Override
            public void run(Job<AaptProcess> job, JobContext<AaptProcess> context) throws IOException {
                QueuedCruncher.this.mLogger.verbose("Thread(%1$s): begin executing job %2$s", new Object[]{Thread.currentThread().getName(), job.getJobTitle()});
                context.getPayload().crunch(from, to, job);
                QueuedCruncher.this.mLogger.verbose("Thread(%1$s): done executing job %2$s", new Object[]{Thread.currentThread().getName(), job.getJobTitle()});
            }
        });
        this.mOutstandingJobs.add(aaptProcessJob);
        this.mCrunchingRequests.push(aaptProcessJob);
    }

    public void waitForAll() throws InterruptedException {
        this.mLogger.verbose("Thread(%1$s): begin waitForAll", new Object[]{Thread.currentThread().getName()});
        Job<AaptProcess> aaptProcessJob = this.mOutstandingJobs.poll();
        while (aaptProcessJob != null) {
            this.mLogger.verbose("Thread(%1$s) : wait for {%2$s)", new Object[]{Thread.currentThread().getName(), aaptProcessJob.toString()});
            if (!aaptProcessJob.await()) {
                throw new RuntimeException("Crunching " + aaptProcessJob.getJobTitle() + " failed, see logs");
            }
            aaptProcessJob = this.mOutstandingJobs.poll();
        }
        this.mLogger.verbose("Thread(%1$s): end waitForAll", new Object[]{Thread.currentThread().getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            this.waitForAll();
            this.mOutstandingJobs.clear();
            this.mLogger.verbose("Job finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
        }
        catch (Throwable throwable) {
            this.mCrunchingRequests.shutdown();
            this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
            throw throwable;
        }
        this.mCrunchingRequests.shutdown();
        this.mLogger.verbose("Shutdown finished in %1$d", new Object[]{System.currentTimeMillis() - startTime});
    }

    public static enum Builder {
        INSTANCE;

        private final Map<String, QueuedCruncher> sInstances = new ConcurrentHashMap<String, QueuedCruncher>();
        private final Object sLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueuedCruncher newCruncher(@NonNull String aaptLocation, @NonNull ILogger logger) {
            Object object = this.sLock;
            synchronized (object) {
                if (!this.sInstances.containsKey(aaptLocation)) {
                    QueuedCruncher queuedCruncher = new QueuedCruncher(aaptLocation, logger);
                    this.sInstances.put(aaptLocation, queuedCruncher);
                }
                return this.sInstances.get(aaptLocation);
            }
        }
    }
}

