/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.google.common.collect.ImmutableList;

public enum VariantType {
    DEFAULT,
    LIBRARY,
    ANDROID_TEST("androidTest", "AndroidTest", "_android_test_", 1),
    UNIT_TEST("test", "UnitTest", "_unit_test_", 2);

    private final boolean mIsForTesting;
    private final String mPrefix;
    private final String mSuffix;
    private final String mArtifactName;
    private final int mArtifactType;

    public static ImmutableList<VariantType> getTestingTypes() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (VariantType variantType : VariantType.values()) {
            if (!variantType.isForTesting()) continue;
            result.add((Object)variantType);
        }
        return result.build();
    }

    private VariantType() {
        this.mIsForTesting = false;
        this.mPrefix = "";
        this.mSuffix = "";
        this.mArtifactName = "_main_";
        this.mArtifactType = 1;
    }

    private VariantType(String prefix, String suffix, String artifactName, int artifactType) {
        this.mArtifactName = artifactName;
        this.mArtifactType = artifactType;
        this.mIsForTesting = true;
        this.mPrefix = prefix;
        this.mSuffix = suffix;
    }

    public boolean isForTesting() {
        return this.mIsForTesting;
    }

    @NonNull
    public String getPrefix() {
        return this.mPrefix;
    }

    @NonNull
    public String getSuffix() {
        return this.mSuffix;
    }

    @NonNull
    public String getArtifactName() {
        return this.mArtifactName;
    }

    public int getArtifactType() {
        return this.mArtifactType;
    }
}

