/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Immutable
public abstract class LibraryBundle
implements LibraryDependency {
    public static final String FN_PROGUARD_TXT = "proguard.txt";
    private final File mBundle;
    private final File mBundleFolder;
    private final String mName;
    private final String mProjectPath;

    protected LibraryBundle(@NonNull File bundle, @NonNull File bundleFolder, @Nullable String name, @Nullable String projectPath) {
        this.mBundle = bundle;
        this.mBundleFolder = bundleFolder;
        this.mName = name;
        this.mProjectPath = projectPath;
    }

    @Override
    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getProject() {
        return this.mProjectPath;
    }

    @Nullable
    public String getProjectVariant() {
        return null;
    }

    @Override
    @NonNull
    public File getManifest() {
        return new File(this.mBundleFolder, "AndroidManifest.xml");
    }

    @Override
    @NonNull
    public File getSymbolFile() {
        return new File(this.mBundleFolder, "R.txt");
    }

    @NonNull
    public File getBundle() {
        return this.mBundle;
    }

    @NonNull
    public File getFolder() {
        return this.mBundleFolder;
    }

    @NonNull
    public File getJarFile() {
        return new File(this.getJarsRootFolder(), "classes.jar");
    }

    @NonNull
    public List<JarDependency> getLocalDependencies() {
        Collection jars = this.getLocalJars();
        ArrayList localDependencies = Lists.newArrayListWithCapacity((int)jars.size());
        for (File jar : jars) {
            localDependencies.add(new JarDependency(jar, true, true, null, null));
        }
        return localDependencies;
    }

    @NonNull
    public List<File> getLocalJars() {
        ArrayList localJars = Lists.newArrayList();
        File[] jarList = new File(this.getJarsRootFolder(), "libs").listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    @NonNull
    public File getResFolder() {
        return new File(this.mBundleFolder, "res");
    }

    @NonNull
    public File getAssetsFolder() {
        return new File(this.mBundleFolder, "assets");
    }

    @NonNull
    public File getJniFolder() {
        return new File(this.mBundleFolder, "jni");
    }

    @NonNull
    public File getAidlFolder() {
        return new File(this.mBundleFolder, "aidl");
    }

    @NonNull
    public File getRenderscriptFolder() {
        return new File(this.mBundleFolder, "rs");
    }

    @NonNull
    public File getProguardRules() {
        return new File(this.mBundleFolder, FN_PROGUARD_TXT);
    }

    @NonNull
    public File getLintJar() {
        return new File(this.mBundleFolder, "lint.jar");
    }

    @NonNull
    public File getExternalAnnotations() {
        return new File(this.mBundleFolder, "annotations.zip");
    }

    @NonNull
    public File getBundleFolder() {
        return this.mBundleFolder;
    }

    @NonNull
    protected File getJarsRootFolder() {
        return new File(this.mBundleFolder, "jars");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryBundle that = (LibraryBundle)o;
        return Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mProjectPath, (Object)that.mProjectPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mProjectPath});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mBundle", (Object)this.mBundle).add("mBundleFolder", (Object)this.mBundleFolder).add("mName", (Object)this.mName).add("mProjectPath", (Object)this.mProjectPath).toString();
    }
}

