/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.GuardedBy;
import com.android.annotations.concurrency.Immutable;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PreProcessCache<T extends Key> {
    private static final String NODE_ITEMS = "items";
    private static final String NODE_ITEM = "item";
    private static final String NODE_DEX = "dex";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_JAR = "jar";
    private static final String ATTR_DEX = "dex";
    private static final String ATTR_SHA1 = "sha1";
    private static final String ATTR_REVISION = "revision";
    private static final String XML_VERSION = "2";
    @GuardedBy(value="this")
    private boolean mLoaded = false;
    @GuardedBy(value="this")
    private final Map<T, Item> mMap = Maps.newHashMap();
    @GuardedBy(value="this")
    private final Map<T, StoredItem> mStoredItems = Maps.newHashMap();
    @GuardedBy(value="this")
    private int mMisses = 0;
    @GuardedBy(value="this")
    private int mHits = 0;

    @NonNull
    protected abstract KeyFactory<T> getKeyFactory();

    public synchronized void load(@NonNull File itemStorage) {
        if (this.mLoaded) {
            return;
        }
        this.loadItems(itemStorage);
        this.mLoaded = true;
    }

    protected synchronized Pair<Item, Boolean> getItem(@NonNull T itemKey) {
        Item item = this.mMap.get(itemKey);
        boolean newItem = false;
        if (item == null) {
            StoredItem storedItem = this.mStoredItems.get(itemKey);
            File inputFile = ((Key)itemKey).getSourceFile();
            if (storedItem != null && storedItem.areOutputFilesPresent() && storedItem.getSourceHash().equals((Object)PreProcessCache.getHash(inputFile))) {
                Logger.getAnonymousLogger().info("Cached result for getItem(" + inputFile + "): " + storedItem.getOutputFiles());
                for (File f : storedItem.getOutputFiles()) {
                    Logger.getAnonymousLogger().info(String.format("%s l:%d ts:%d", f, f.length(), f.lastModified()));
                }
                item = new Item(inputFile, storedItem.getOutputFiles(), new CountDownLatch(0));
            }
            if (item == null) {
                item = new Item(inputFile, new CountDownLatch(1));
                newItem = true;
            }
            this.mMap.put(itemKey, item);
        }
        return Pair.of((Object)item, (Object)newItem);
    }

    @Nullable
    private static HashCode getHash(@NonNull File file) {
        try {
            return Files.hash((File)file, (HashFunction)Hashing.sha1());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized void clear(@Nullable File itemStorage, @Nullable ILogger logger) throws IOException {
        if (!this.mMap.isEmpty()) {
            if (itemStorage != null) {
                this.saveItems(itemStorage);
            }
            if (logger != null) {
                logger.info("PREDEX CACHE HITS:   " + this.mHits, new Object[0]);
                logger.info("PREDEX CACHE MISSES: " + this.mMisses, new Object[0]);
            }
        }
        this.mMap.clear();
        this.mStoredItems.clear();
        this.mHits = 0;
        this.mMisses = 0;
    }

    private synchronized void loadItems(@NonNull File itemStorage) {
        if (!itemStorage.isFile()) {
            return;
        }
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)itemStorage, (boolean)true);
            Element rootNode = document.getDocumentElement();
            if (rootNode == null || !NODE_ITEMS.equals(rootNode.getLocalName())) {
                return;
            }
            NamedNodeMap rootAttrMap = rootNode.getAttributes();
            Node versionAttr = rootAttrMap.getNamedItem(ATTR_VERSION);
            if (versionAttr == null || !XML_VERSION.equals(versionAttr.getNodeValue())) {
                return;
            }
            NodeList nodes = rootNode.getChildNodes();
            int n = nodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !NODE_ITEM.equals(node.getLocalName())) continue;
                NamedNodeMap attrMap = node.getAttributes();
                File sourceFile = new File(attrMap.getNamedItem(ATTR_JAR).getNodeValue());
                FullRevision revision = FullRevision.parseRevision((String)attrMap.getNamedItem(ATTR_REVISION).getNodeValue());
                ArrayList outputFiles = Lists.newArrayList();
                NodeList dexNodes = node.getChildNodes();
                int m = dexNodes.getLength();
                for (int j = 0; j < m; ++j) {
                    Node dexNode = dexNodes.item(j);
                    if (dexNode.getNodeType() != 1 || !"dex".equals(dexNode.getLocalName())) continue;
                    NamedNodeMap dexAttrMap = dexNode.getAttributes();
                    outputFiles.add(new File(dexAttrMap.getNamedItem("dex").getNodeValue()));
                }
                StoredItem item = new StoredItem(sourceFile, outputFiles, HashCode.fromString((String)attrMap.getNamedItem(ATTR_SHA1).getNodeValue()));
                Key key = (Key)this.getKeyFactory().of(sourceFile, revision, attrMap);
                this.mStoredItems.put(key, item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void saveItems(@NonNull File itemStorage) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootNode = document.createElement(NODE_ITEMS);
            document.appendChild(rootNode);
            Attr attr = document.createAttribute(ATTR_VERSION);
            attr.setValue(XML_VERSION);
            rootNode.getAttributes().setNamedItem(attr);
            HashSet keys = Sets.newHashSetWithExpectedSize((int)(this.mMap.size() + this.mStoredItems.size()));
            keys.addAll(this.mMap.keySet());
            keys.addAll(this.mStoredItems.keySet());
            for (Key key : keys) {
                Node itemNode;
                Item item = this.mMap.get(key);
                if (item != null) {
                    Node itemNode2 = this.createItemNode(document, key, item);
                    if (itemNode2 == null) continue;
                    rootNode.appendChild(itemNode2);
                    continue;
                }
                StoredItem storedItem = this.mStoredItems.get(key);
                if (storedItem == null || !storedItem.getSourceFile().isFile() || !storedItem.areOutputFilesPresent() || (itemNode = this.createItemNode(document, key, storedItem)) == null) continue;
                rootNode.appendChild(itemNode);
            }
            String content = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
            itemStorage.getParentFile().mkdirs();
            Files.write((CharSequence)content, (File)itemStorage, (Charset)Charsets.UTF_8);
        }
        catch (ParserConfigurationException e) {
            // empty catch block
        }
    }

    @Nullable
    protected Node createItemNode(@NonNull Document document, @NonNull T itemKey, @NonNull BaseItem item) throws IOException {
        if (!item.areOutputFilesPresent()) {
            return null;
        }
        Element itemNode = document.createElement(NODE_ITEM);
        Attr attr = document.createAttribute(ATTR_JAR);
        attr.setValue(item.getSourceFile().getPath());
        itemNode.getAttributes().setNamedItem(attr);
        attr = document.createAttribute(ATTR_REVISION);
        attr.setValue(((Key)itemKey).getBuildToolsRevision().toString());
        itemNode.getAttributes().setNamedItem(attr);
        HashCode hashCode = item.getSourceHash();
        if (hashCode == null) {
            try {
                hashCode = Files.hash((File)item.getSourceFile(), (HashFunction)Hashing.sha1());
            }
            catch (IOException ex) {
                return null;
            }
        }
        attr = document.createAttribute(ATTR_SHA1);
        attr.setValue(hashCode.toString());
        itemNode.getAttributes().setNamedItem(attr);
        for (File dexFile : item.getOutputFiles()) {
            Element dexNode = document.createElement("dex");
            itemNode.appendChild(dexNode);
            attr = document.createAttribute("dex");
            attr.setValue(dexFile.getPath());
            dexNode.getAttributes().setNamedItem(attr);
        }
        return itemNode;
    }

    protected synchronized void incrementMisses() {
        ++this.mMisses;
    }

    protected synchronized void incrementHits() {
        ++this.mHits;
    }

    synchronized int getMisses() {
        return this.mMisses;
    }

    synchronized int getHits() {
        return this.mHits;
    }

    protected static interface KeyFactory<T> {
        public T of(@NonNull File var1, @NonNull FullRevision var2, @NonNull NamedNodeMap var3);
    }

    @Immutable
    protected static class Key {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final FullRevision mBuildToolsRevision;

        public static Key of(@NonNull File sourceFile, @NonNull FullRevision buildToolsRevision) {
            return new Key(sourceFile, buildToolsRevision);
        }

        protected Key(@NonNull File sourceFile, @NonNull FullRevision buildToolsRevision) {
            this.mSourceFile = sourceFile;
            this.mBuildToolsRevision = buildToolsRevision;
        }

        @NonNull
        public FullRevision getBuildToolsRevision() {
            return this.mBuildToolsRevision;
        }

        @NonNull
        public File getSourceFile() {
            return this.mSourceFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (!this.mBuildToolsRevision.equals((Object)key.mBuildToolsRevision)) {
                return false;
            }
            return this.mSourceFile.equals(key.mSourceFile);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mSourceFile, this.mBuildToolsRevision});
        }
    }

    @Immutable
    protected static class StoredItem
    implements BaseItem {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final List<File> mOutputFiles;
        @NonNull
        private final HashCode mSourceHash;

        StoredItem(@NonNull File sourceFile, @NonNull List<File> outputFiles, @NonNull HashCode sourceHash) {
            this.mSourceFile = sourceFile;
            this.mOutputFiles = Lists.newArrayList(outputFiles);
            this.mSourceHash = sourceHash;
        }

        @Override
        @NonNull
        public File getSourceFile() {
            return this.mSourceFile;
        }

        @Override
        @NonNull
        public List<File> getOutputFiles() {
            return this.mOutputFiles;
        }

        @Override
        @NonNull
        public HashCode getSourceHash() {
            return this.mSourceHash;
        }

        @Override
        public boolean areOutputFilesPresent() {
            boolean filesOk = !this.mOutputFiles.isEmpty();
            for (File outputFile : this.mOutputFiles) {
                filesOk &= outputFile.isFile();
            }
            return filesOk;
        }

        public String toString() {
            return "StoredItem{mSourceFile=" + this.mSourceFile + ", mOutputFiles=" + this.mOutputFiles + ", mSourceHash=" + this.mSourceHash + '}';
        }
    }

    @Immutable
    protected static class Item
    implements BaseItem {
        @NonNull
        private final File mSourceFile;
        @NonNull
        private final List<File> mOutputFiles;
        @NonNull
        private final CountDownLatch mLatch;

        Item(@NonNull File sourceFile, @NonNull List<File> outputFiles, @NonNull CountDownLatch latch) {
            this.mSourceFile = sourceFile;
            this.mOutputFiles = Lists.newArrayList(outputFiles);
            this.mLatch = latch;
        }

        Item(@NonNull File sourceFile, @NonNull CountDownLatch latch) {
            this.mSourceFile = sourceFile;
            this.mOutputFiles = Lists.newArrayList();
            this.mLatch = latch;
        }

        @Override
        @NonNull
        public File getSourceFile() {
            return this.mSourceFile;
        }

        @Override
        @NonNull
        public List<File> getOutputFiles() {
            return this.mOutputFiles;
        }

        @Override
        @Nullable
        public HashCode getSourceHash() {
            return null;
        }

        @NonNull
        protected CountDownLatch getLatch() {
            return this.mLatch;
        }

        @Override
        public boolean areOutputFilesPresent() {
            boolean filesOk = !this.mOutputFiles.isEmpty();
            for (File outputFile : this.mOutputFiles) {
                filesOk &= outputFile.isFile();
            }
            return filesOk;
        }

        public String toString() {
            return "Item{mOutputFiles=" + this.mOutputFiles + ", mSourceFile=" + this.mSourceFile + '}';
        }
    }

    protected static interface BaseItem {
        @NonNull
        public File getSourceFile();

        @NonNull
        public List<File> getOutputFiles();

        @Nullable
        public HashCode getSourceHash();

        public boolean areOutputFilesPresent();
    }
}

