/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultProductFlavor
extends BaseConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    @Nullable
    private String mDimension;
    @Nullable
    private ApiVersion mMinSdkVersion;
    @Nullable
    private ApiVersion mTargetSdkVersion;
    @Nullable
    private Integer mMaxSdkVersion;
    @Nullable
    private Integer mRenderscriptTargetApi;
    @Nullable
    private Boolean mRenderscriptSupportModeEnabled;
    @Nullable
    private Boolean mRenderscriptNdkModeEnabled;
    @Nullable
    private Integer mVersionCode;
    @Nullable
    private String mVersionName;
    @Nullable
    private String mApplicationId;
    @Nullable
    private String mTestApplicationId;
    @Nullable
    private String mTestInstrumentationRunner;
    @NonNull
    private Map<String, String> mTestInstrumentationRunnerArguments = Maps.newHashMap();
    @Nullable
    private Boolean mTestHandleProfiling;
    @Nullable
    private Boolean mTestFunctionalTest;
    @Nullable
    private SigningConfig mSigningConfig;
    @Nullable
    private Set<String> mResourceConfiguration;

    public DefaultProductFlavor(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public void setDimension(@NonNull String dimension) {
        this.mDimension = dimension;
    }

    @Nullable
    public String getDimension() {
        return this.mDimension;
    }

    @NonNull
    public ProductFlavor setApplicationId(String applicationId) {
        this.mApplicationId = applicationId;
        return this;
    }

    @Nullable
    public String getApplicationId() {
        return this.mApplicationId;
    }

    @NonNull
    public ProductFlavor setVersionCode(Integer versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    @NonNull
    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @NonNull
    public ProductFlavor setMinSdkVersion(ApiVersion minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    @Nullable
    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @NonNull
    public ProductFlavor setTargetSdkVersion(ApiVersion targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    @Nullable
    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @NonNull
    public ProductFlavor setMaxSdkVersion(Integer maxSdkVersion) {
        this.mMaxSdkVersion = maxSdkVersion;
        return this;
    }

    @Nullable
    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    @Nullable
    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(Integer renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    @Nullable
    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportModeEnabled;
    }

    public ProductFlavor setRenderscriptSupportModeEnabled(Boolean renderscriptSupportMode) {
        this.mRenderscriptSupportModeEnabled = renderscriptSupportMode;
        return this;
    }

    @Nullable
    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkModeEnabled;
    }

    public ProductFlavor setRenderscriptNdkModeEnabled(Boolean renderscriptNdkMode) {
        this.mRenderscriptNdkModeEnabled = renderscriptNdkMode;
        return this;
    }

    @NonNull
    public ProductFlavor setTestApplicationId(String applicationId) {
        this.mTestApplicationId = applicationId;
        return this;
    }

    @Nullable
    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    @NonNull
    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @NonNull
    public ProductFlavor setTestInstrumentationRunnerArguments(@NonNull Map<String, String> testInstrumentationRunnerArguments) {
        this.mTestInstrumentationRunnerArguments = (Map)Preconditions.checkNotNull(testInstrumentationRunnerArguments);
        return this;
    }

    @NonNull
    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.mTestInstrumentationRunnerArguments;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    @NonNull
    public ProductFlavor setTestHandleProfiling(boolean handleProfiling) {
        this.mTestHandleProfiling = handleProfiling;
        return this;
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    @NonNull
    public ProductFlavor setTestFunctionalTest(boolean functionalTest) {
        this.mTestFunctionalTest = functionalTest;
        return this;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @NonNull
    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    public void addResourceConfiguration(@NonNull String configuration) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.add(configuration);
    }

    public void addResourceConfigurations(String ... configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(Arrays.asList(configurations));
    }

    public void addResourceConfigurations(@NonNull Collection<String> configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(configurations);
    }

    @NonNull
    public Collection<String> getResourceConfigurations() {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        return this.mResourceConfiguration;
    }

    @NonNull
    static ProductFlavor mergeFlavors(@NonNull ProductFlavor base, @NonNull ProductFlavor overlay) {
        DefaultProductFlavor flavor = new DefaultProductFlavor("");
        flavor.mMinSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMinSdkVersion(), base.getMinSdkVersion());
        flavor.mTargetSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getTargetSdkVersion(), base.getTargetSdkVersion());
        flavor.mMaxSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMaxSdkVersion(), base.getMaxSdkVersion());
        flavor.mRenderscriptTargetApi = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptTargetApi(), base.getRenderscriptTargetApi());
        flavor.mRenderscriptSupportModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeEnabled(), base.getRenderscriptSupportModeEnabled());
        flavor.mRenderscriptNdkModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptNdkModeEnabled(), base.getRenderscriptNdkModeEnabled());
        flavor.mVersionCode = DefaultProductFlavor.chooseNotNull(overlay.getVersionCode(), base.getVersionCode());
        flavor.mVersionName = DefaultProductFlavor.chooseNotNull(overlay.getVersionName(), base.getVersionName());
        flavor.mApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getApplicationId(), base.getApplicationId());
        flavor.mTestApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getTestApplicationId(), base.getTestApplicationId());
        flavor.mTestInstrumentationRunner = DefaultProductFlavor.chooseNotNull(overlay.getTestInstrumentationRunner(), base.getTestInstrumentationRunner());
        flavor.mTestInstrumentationRunnerArguments.putAll(base.getTestInstrumentationRunnerArguments());
        flavor.mTestInstrumentationRunnerArguments.putAll(overlay.getTestInstrumentationRunnerArguments());
        flavor.mTestHandleProfiling = DefaultProductFlavor.chooseNotNull(overlay.getTestHandleProfiling(), base.getTestHandleProfiling());
        flavor.mTestFunctionalTest = DefaultProductFlavor.chooseNotNull(overlay.getTestFunctionalTest(), base.getTestFunctionalTest());
        flavor.mSigningConfig = DefaultProductFlavor.chooseNotNull(overlay.getSigningConfig(), base.getSigningConfig());
        flavor.addResourceConfigurations(base.getResourceConfigurations());
        flavor.addResourceConfigurations(overlay.getResourceConfigurations());
        flavor.addManifestPlaceholders(base.getManifestPlaceholders());
        flavor.addManifestPlaceholders(overlay.getManifestPlaceholders());
        flavor.addResValues(base.getResValues());
        flavor.addResValues(overlay.getResValues());
        flavor.addBuildConfigFields(base.getBuildConfigFields());
        flavor.addBuildConfigFields(overlay.getBuildConfigFields());
        flavor.setMultiDexEnabled(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexEnabled(), base.getMultiDexEnabled()));
        flavor.setMultiDexKeepFile(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepFile(), base.getMultiDexKeepFile()));
        flavor.setMultiDexKeepProguard(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepProguard(), base.getMultiDexKeepProguard()));
        flavor.setJarJarRuleFiles((List<File>)ImmutableList.builder().addAll((Iterable)overlay.getJarJarRuleFiles()).addAll((Iterable)base.getJarJarRuleFiles()).build());
        return flavor;
    }

    @NonNull
    static ProductFlavor clone(@NonNull ProductFlavor productFlavor) {
        DefaultProductFlavor flavor = new DefaultProductFlavor(productFlavor.getName());
        flavor._initWith((BaseConfig)productFlavor);
        flavor.mDimension = productFlavor.getDimension();
        flavor.mMinSdkVersion = productFlavor.getMinSdkVersion();
        flavor.mTargetSdkVersion = productFlavor.getTargetSdkVersion();
        flavor.mMaxSdkVersion = productFlavor.getMaxSdkVersion();
        flavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        flavor.mRenderscriptSupportModeEnabled = productFlavor.getRenderscriptSupportModeEnabled();
        flavor.mRenderscriptNdkModeEnabled = productFlavor.getRenderscriptNdkModeEnabled();
        flavor.mVersionCode = productFlavor.getVersionCode();
        flavor.mVersionName = productFlavor.getVersionName();
        flavor.mApplicationId = productFlavor.getApplicationId();
        flavor.mTestApplicationId = productFlavor.getTestApplicationId();
        flavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        flavor.mTestInstrumentationRunnerArguments = productFlavor.getTestInstrumentationRunnerArguments();
        flavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        flavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        flavor.mSigningConfig = productFlavor.getSigningConfig();
        flavor.addResourceConfigurations(productFlavor.getResourceConfigurations());
        flavor.addManifestPlaceholders(productFlavor.getManifestPlaceholders());
        flavor.addResValues(productFlavor.getResValues());
        flavor.addBuildConfigFields(productFlavor.getBuildConfigFields());
        flavor.setMultiDexEnabled(productFlavor.getMultiDexEnabled());
        flavor.setMultiDexKeepFile(productFlavor.getMultiDexKeepFile());
        flavor.setMultiDexKeepProguard(productFlavor.getMultiDexKeepProguard());
        flavor.setJarJarRuleFiles((List<File>)ImmutableList.copyOf((Collection)productFlavor.getJarJarRuleFiles()));
        return flavor;
    }

    private static <T> T chooseNotNull(T overlay, T base) {
        return overlay != null ? overlay : base;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultProductFlavor that = (DefaultProductFlavor)o;
        return Objects.equal((Object)this.mDimension, (Object)that.mDimension) && Objects.equal((Object)this.mApplicationId, (Object)that.mApplicationId) && Objects.equal((Object)this.mMaxSdkVersion, (Object)that.mMaxSdkVersion) && Objects.equal((Object)this.mMinSdkVersion, (Object)that.mMinSdkVersion) && Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mRenderscriptNdkModeEnabled, (Object)that.mRenderscriptNdkModeEnabled) && Objects.equal((Object)this.mRenderscriptSupportModeEnabled, (Object)that.mRenderscriptSupportModeEnabled) && Objects.equal((Object)this.mRenderscriptTargetApi, (Object)that.mRenderscriptTargetApi) && Objects.equal(this.mResourceConfiguration, that.mResourceConfiguration) && Objects.equal((Object)this.mSigningConfig, (Object)that.mSigningConfig) && Objects.equal((Object)this.mTargetSdkVersion, (Object)that.mTargetSdkVersion) && Objects.equal((Object)this.mTestApplicationId, (Object)that.mTestApplicationId) && Objects.equal((Object)this.mTestFunctionalTest, (Object)that.mTestFunctionalTest) && Objects.equal((Object)this.mTestHandleProfiling, (Object)that.mTestHandleProfiling) && Objects.equal((Object)this.mTestInstrumentationRunner, (Object)that.mTestInstrumentationRunner) && Objects.equal(this.mTestInstrumentationRunnerArguments, that.mTestInstrumentationRunnerArguments) && Objects.equal((Object)this.mVersionCode, (Object)that.mVersionCode) && Objects.equal((Object)this.mVersionName, (Object)that.mVersionName);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mName, this.mDimension, this.mMinSdkVersion, this.mTargetSdkVersion, this.mMaxSdkVersion, this.mRenderscriptTargetApi, this.mRenderscriptSupportModeEnabled, this.mRenderscriptNdkModeEnabled, this.mVersionCode, this.mVersionName, this.mApplicationId, this.mTestApplicationId, this.mTestInstrumentationRunner, this.mTestInstrumentationRunnerArguments, this.mTestHandleProfiling, this.mTestFunctionalTest, this.mSigningConfig, this.mResourceConfiguration});
    }

    @Override
    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("dimension", (Object)this.mDimension).add("minSdkVersion", (Object)this.mMinSdkVersion).add("targetSdkVersion", (Object)this.mTargetSdkVersion).add("renderscriptTargetApi", (Object)this.mRenderscriptTargetApi).add("renderscriptSupportModeEnabled", (Object)this.mRenderscriptSupportModeEnabled).add("renderscriptNdkModeEnabled", (Object)this.mRenderscriptNdkModeEnabled).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).add("applicationId", (Object)this.mApplicationId).add("testApplicationId", (Object)this.mTestApplicationId).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("testInstrumentationRunnerArguments", this.mTestInstrumentationRunnerArguments).add("testHandleProfiling", (Object)this.mTestHandleProfiling).add("testFunctionalTest", (Object)this.mTestFunctionalTest).add("signingConfig", (Object)this.mSigningConfig).add("resConfig", this.mResourceConfiguration).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).toString();
    }
}

