/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Preconditions;
import java.io.File;

public class JarDependency {
    @NonNull
    private final File mJarFile;
    private final boolean mCompiled;
    private final boolean mPackaged;
    private final boolean mProguarded;
    @Nullable
    private final String mProjectPath;
    @Nullable
    private final MavenCoordinates mResolvedCoordinates;

    public JarDependency(@NonNull File jarFile, boolean compiled, boolean packaged, boolean proguarded, @Nullable MavenCoordinates resolvedCoordinates, @Nullable String projectPath) {
        Preconditions.checkNotNull((Object)jarFile);
        this.mJarFile = jarFile;
        this.mCompiled = compiled;
        this.mPackaged = packaged;
        this.mProguarded = proguarded;
        this.mResolvedCoordinates = resolvedCoordinates;
        this.mProjectPath = projectPath;
    }

    public JarDependency(@NonNull File jarFile, boolean compiled, boolean packaged, @Nullable MavenCoordinates resolvedCoordinates, @Nullable String projectPath) {
        this(jarFile, compiled, packaged, true, resolvedCoordinates, projectPath);
    }

    @NonNull
    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isCompiled() {
        return this.mCompiled;
    }

    public boolean isPackaged() {
        return this.mPackaged;
    }

    public boolean isProguarded() {
        return this.mProguarded;
    }

    @Nullable
    public MavenCoordinates getResolvedCoordinates() {
        return this.mResolvedCoordinates;
    }

    @Nullable
    public String getProjectPath() {
        return this.mProjectPath;
    }

    public String toString() {
        return "JarDependency{mJarFile=" + this.mJarFile + ", mCompiled=" + this.mCompiled + ", mPackaged=" + this.mPackaged + ", mProguarded=" + this.mProguarded + ", mResolvedCoordinates=" + this.mResolvedCoordinates + '}';
    }
}

