/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.testing.api.DeviceConfig;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.utils.ILogger;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ConnectedDevice
extends DeviceConnector {
    private final IDevice iDevice;

    public ConnectedDevice(IDevice iDevice) {
        this.iDevice = iDevice;
    }

    public String getName() {
        String model;
        String version = this.iDevice.getProperty("ro.build.version.release");
        boolean emulator = this.iDevice.isEmulator();
        String name = emulator ? (this.iDevice.getAvdName() != null ? this.iDevice.getAvdName() + "(AVD)" : this.iDevice.getSerialNumber()) : ((model = this.iDevice.getProperty("ro.product.model")) != null ? model : this.iDevice.getSerialNumber());
        return version != null ? name + " - " + version : name;
    }

    public void connect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void disconnect(int timeout, ILogger logger) throws TimeoutException {
    }

    public void installPackage(File apkFile, Collection<String> options, int timeout, ILogger logger) throws DeviceException {
        try {
            this.iDevice.installPackage(apkFile.getAbsolutePath(), true, options.isEmpty() ? null : options.toArray(new String[options.size()]));
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to install " + apkFile.getAbsolutePath(), new Object[0]);
            throw new DeviceException((Throwable)e);
        }
    }

    public void installPackages(List<File> splitApkFiles, Collection<String> options, int timeoutInMs, ILogger logger) throws DeviceException {
        List apkFileNames = Lists.transform(splitApkFiles, (Function)new Function<File, String>(){

            public String apply(File input) {
                return input != null ? input.getAbsolutePath() : null;
            }
        });
        try {
            this.iDevice.installPackages(apkFileNames, timeoutInMs, true, options.isEmpty() ? null : options.toArray(new String[options.size()]));
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to install " + Joiner.on((char)',').join((Iterable)apkFileNames), new Object[0]);
            throw new DeviceException((Throwable)e);
        }
    }

    public void uninstallPackage(String packageName, int timeout, ILogger logger) throws DeviceException {
        try {
            this.iDevice.uninstallPackage(packageName);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Unable to uninstall " + packageName, new Object[0]);
            throw new DeviceException((Throwable)e);
        }
    }

    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.iDevice.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    public Future<String> getSystemProperty(String name) {
        return this.iDevice.getSystemProperty(name);
    }

    public void pullFile(String remote, String local) throws IOException {
        try {
            this.iDevice.pullFile(remote, local);
        }
        catch (TimeoutException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
        catch (AdbCommandRejectedException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
        catch (SyncException e) {
            throw new IOException(String.format("Failed to pull %s from device", remote), e);
        }
    }

    public String getSerialNumber() {
        return this.iDevice.getSerialNumber();
    }

    public int getApiLevel() {
        String sdkVersion = this.iDevice.getProperty("ro.build.version.sdk");
        if (sdkVersion != null) {
            try {
                return Integer.valueOf(sdkVersion);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getApiCodeName() {
        String codeName = this.iDevice.getProperty("ro.build.version.codename");
        if (codeName != null) {
            if ("REL".equals(codeName)) {
                return null;
            }
            return codeName;
        }
        return null;
    }

    public IDevice.DeviceState getState() {
        return this.iDevice.getState();
    }

    public List<String> getAbis() {
        return this.iDevice.getAbis();
    }

    public int getDensity() {
        return this.iDevice.getDensity();
    }

    public int getHeight() {
        return 0;
    }

    public int getWidth() {
        return 0;
    }

    public String getLanguage() {
        return this.iDevice.getLanguage();
    }

    public String getRegion() {
        return this.iDevice.getRegion();
    }

    public String getProperty(String propertyName) {
        return this.iDevice.getProperty(propertyName);
    }

    public DeviceConfig getDeviceConfig() throws DeviceException {
        final ArrayList output = new ArrayList();
        MultiLineReceiver receiver = new MultiLineReceiver(){

            public void processNewLines(String[] lines) {
                output.addAll(Arrays.asList(lines));
            }

            public boolean isCancelled() {
                return false;
            }
        };
        try {
            this.executeShellCommand("am get-config", (IShellOutputReceiver)receiver, 5L, TimeUnit.SECONDS);
            return DeviceConfig.Builder.parse(output);
        }
        catch (Exception e) {
            throw new DeviceException((Throwable)e);
        }
    }
}

