/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.LintGradleClient;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.Variant;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.w3c.dom.Document;

public class LintGradleProject
extends com.android.tools.lint.detector.api.Project {
    protected AndroidVersion mMinSdkVersion;
    protected AndroidVersion mTargetSdkVersion;

    private LintGradleProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull File manifest) {
        super((LintClient)client, dir, referenceDir);
        this.mGradleProject = true;
        this.mMergeManifests = true;
        this.mDirectLibraries = Lists.newArrayList();
        this.readManifest(manifest);
    }

    @NonNull
    public static Pair<LintGradleProject, List<File>> create(@NonNull LintGradleClient client, @NonNull AndroidProject project, @NonNull Variant variant, @NonNull Project gradleProject) {
        File dir = gradleProject.getProjectDir();
        AppGradleProject lintProject = new AppGradleProject(client, dir, dir, project, variant);
        ArrayList customRules = Lists.newArrayList();
        File appLintJar = new File(gradleProject.getBuildDir(), "lint" + File.separatorChar + "lint.jar");
        if (appLintJar.exists()) {
            customRules.add(appLintJar);
        }
        HashSet libraries = Sets.newHashSet();
        Dependencies dependencies = variant.getMainArtifact().getDependencies();
        for (AndroidLibrary library : dependencies.getLibraries()) {
            lintProject.addDirectLibrary(LintGradleProject.createLibrary(client, library, libraries, customRules));
        }
        return Pair.of((Object)((Object)lintProject), (Object)customRules);
    }

    protected void initialize() {
    }

    protected void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                String xml = Files.toString((File)manifest, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document != null) {
                    this.readManifest(document);
                }
            }
            catch (IOException e) {
                this.mClient.log((Throwable)e, "Could not read manifest %1$s", new Object[]{manifest});
            }
        }
    }

    public boolean isGradleProject() {
        return true;
    }

    protected static boolean dependsOn(@NonNull Dependencies dependencies, @NonNull String artifact) {
        for (AndroidLibrary library : dependencies.getLibraries()) {
            if (!LintGradleProject.dependsOn(library, artifact)) continue;
            return true;
        }
        return false;
    }

    protected static boolean dependsOn(@NonNull AndroidLibrary library, @NonNull String artifact) {
        File bundle;
        if ("com.android.support:support-v4".equals(artifact) ? library.getJarFile().getName().startsWith("support-v4-") : "com.android.support:appcompat-v7".equals(artifact) && (bundle = library.getBundle()).getName().startsWith("appcompat-v7-")) {
            return true;
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            if (!LintGradleProject.dependsOn(dependency, artifact)) continue;
            return true;
        }
        return false;
    }

    void addDirectLibrary(@NonNull com.android.tools.lint.detector.api.Project project) {
        this.mDirectLibraries.add(project);
    }

    @NonNull
    private static LibraryProject createLibrary(@NonNull LintGradleClient client, @NonNull AndroidLibrary library, @NonNull Set<AndroidLibrary> seen, List<File> customRules) {
        seen.add(library);
        File dir = library.getFolder();
        LibraryProject project = new LibraryProject(client, dir, dir, library);
        File ruleJar = library.getLintJar();
        if (ruleJar.exists()) {
            customRules.add(ruleJar);
        }
        for (AndroidLibrary dependent : library.getLibraryDependencies()) {
            if (seen.contains(dependent)) continue;
            project.addDirectLibrary(LintGradleProject.createLibrary(client, dependent, seen, customRules));
        }
        return project;
    }

    private static class LibraryProject
    extends LintGradleProject {
        private AndroidLibrary mLibrary;

        private LibraryProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidLibrary library) {
            super(client, dir, referenceDir, library.getManifest());
            this.mLibrary = library;
            this.mReportIssues = false;
        }

        public boolean isLibrary() {
            return true;
        }

        public AndroidLibrary getGradleLibraryModel() {
            return this.mLibrary;
        }

        public Variant getCurrentVariant() {
            return null;
        }

        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                File manifest = this.mLibrary.getManifest();
                this.mManifestFiles = manifest.exists() ? Collections.singletonList(manifest) : Collections.emptyList();
            }
            return this.mManifestFiles;
        }

        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                File proguardRules = this.mLibrary.getProguardRules();
                this.mProguardFiles = proguardRules.exists() ? Collections.singletonList(proguardRules) : Collections.emptyList();
            }
            return this.mProguardFiles;
        }

        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                File folder = this.mLibrary.getResFolder();
                this.mResourceFolders = folder.exists() ? Collections.singletonList(folder) : Collections.emptyList();
            }
            return this.mResourceFolders;
        }

        @NonNull
        public List<File> getJavaSourceFolders() {
            return Collections.emptyList();
        }

        @NonNull
        public List<File> getJavaClassFolders() {
            return Collections.emptyList();
        }

        @NonNull
        public List<File> getJavaLibraries() {
            if (this.mJavaLibraries == null) {
                this.mJavaLibraries = Lists.newArrayList();
                File jarFile = this.mLibrary.getJarFile();
                if (jarFile.exists()) {
                    this.mJavaLibraries.add(jarFile);
                }
                for (File local : this.mLibrary.getLocalJars()) {
                    if (!local.exists()) continue;
                    this.mJavaLibraries.add(local);
                }
            }
            return this.mJavaLibraries;
        }

        @Nullable
        public Boolean dependsOn(@NonNull String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    this.mSupportLib = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    this.mAppCompat = LibraryProject.dependsOn(this.mLibrary, artifact);
                }
                return this.mAppCompat;
            }
            return super.dependsOn(artifact);
        }
    }

    private static class AppGradleProject
    extends LintGradleProject {
        private AndroidProject mProject;
        private Variant mVariant;
        private List<SourceProvider> mProviders;

        private AppGradleProject(@NonNull LintGradleClient client, @NonNull File dir, @NonNull File referenceDir, @NonNull AndroidProject project, @NonNull Variant variant) {
            super(client, dir, referenceDir, variant.getMainArtifact().getGeneratedManifest());
            this.mProject = project;
            this.mVariant = variant;
        }

        public boolean isLibrary() {
            return this.mProject.isLibrary();
        }

        public AndroidProject getGradleProjectModel() {
            return this.mProject;
        }

        public Variant getCurrentVariant() {
            return this.mVariant;
        }

        private List<SourceProvider> getSourceProviders() {
            if (this.mProviders == null) {
                SourceProvider variantProvider;
                ArrayList providers = Lists.newArrayList();
                AndroidArtifact mainArtifact = this.mVariant.getMainArtifact();
                providers.add(this.mProject.getDefaultConfig().getSourceProvider());
                block0: for (String flavorName : this.mVariant.getProductFlavors()) {
                    for (ProductFlavorContainer flavor : this.mProject.getProductFlavors()) {
                        if (!flavorName.equals(flavor.getProductFlavor().getName())) continue;
                        providers.add(flavor.getSourceProvider());
                        continue block0;
                    }
                }
                SourceProvider multiProvider = mainArtifact.getMultiFlavorSourceProvider();
                if (multiProvider != null) {
                    providers.add(multiProvider);
                }
                String buildTypeName = this.mVariant.getBuildType();
                for (BuildTypeContainer buildType : this.mProject.getBuildTypes()) {
                    if (!buildTypeName.equals(buildType.getBuildType().getName())) continue;
                    providers.add(buildType.getSourceProvider());
                    break;
                }
                if ((variantProvider = mainArtifact.getVariantSourceProvider()) != null) {
                    providers.add(variantProvider);
                }
                this.mProviders = providers;
            }
            return this.mProviders;
        }

        @NonNull
        public List<File> getManifestFiles() {
            if (this.mManifestFiles == null) {
                this.mManifestFiles = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    File manifestFile = provider.getManifestFile();
                    if (!manifestFile.exists()) continue;
                    this.mManifestFiles.add(manifestFile);
                }
            }
            return this.mManifestFiles;
        }

        @NonNull
        public List<File> getProguardFiles() {
            if (this.mProguardFiles == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                this.mProguardFiles = Lists.newArrayList();
                for (File file : flavor.getProguardFiles()) {
                    if (!file.exists()) continue;
                    this.mProguardFiles.add(file);
                }
                try {
                    for (File file : flavor.getConsumerProguardFiles()) {
                        if (!file.exists()) continue;
                        this.mProguardFiles.add(file);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.mProguardFiles;
        }

        @NonNull
        public List<File> getResourceFolders() {
            if (this.mResourceFolders == null) {
                this.mResourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection resDirs = provider.getResDirectories();
                    for (File res : resDirs) {
                        if (!res.exists()) continue;
                        this.mResourceFolders.add(res);
                    }
                }
                for (File file : this.mVariant.getMainArtifact().getGeneratedResourceFolders()) {
                    if (!file.exists()) continue;
                    this.mResourceFolders.add(file);
                }
            }
            return this.mResourceFolders;
        }

        @NonNull
        public List<File> getJavaSourceFolders() {
            if (this.mJavaSourceFolders == null) {
                this.mJavaSourceFolders = Lists.newArrayList();
                for (SourceProvider provider : this.getSourceProviders()) {
                    Collection srcDirs = provider.getJavaDirectories();
                    for (File srcDir : srcDirs) {
                        if (!srcDir.exists()) continue;
                        this.mJavaSourceFolders.add(srcDir);
                    }
                }
                for (File file : this.mVariant.getMainArtifact().getGeneratedSourceFolders()) {
                    if (!file.exists()) continue;
                    this.mJavaSourceFolders.add(file);
                }
            }
            return this.mJavaSourceFolders;
        }

        @NonNull
        public List<File> getJavaClassFolders() {
            if (this.mJavaClassFolders == null) {
                this.mJavaClassFolders = new ArrayList(1);
                File outputClassFolder = this.mVariant.getMainArtifact().getClassesFolder();
                if (outputClassFolder.exists()) {
                    this.mJavaClassFolders.add(outputClassFolder);
                }
            }
            return this.mJavaClassFolders;
        }

        @NonNull
        public List<File> getJavaLibraries() {
            if (this.mJavaLibraries == null) {
                Collection libs = this.mVariant.getMainArtifact().getDependencies().getJavaLibraries();
                this.mJavaLibraries = Lists.newArrayListWithExpectedSize((int)libs.size());
                for (JavaLibrary lib : libs) {
                    File jar = lib.getJarFile();
                    if (!jar.exists()) continue;
                    this.mJavaLibraries.add(jar);
                }
            }
            return this.mJavaLibraries;
        }

        @Nullable
        public String getPackage() {
            String packageName;
            if (this.mPackage == null && (packageName = this.mProject.getDefaultConfig().getProductFlavor().getApplicationId()) != null) {
                return packageName;
            }
            return this.mPackage;
        }

        @NonNull
        public AndroidVersion getMinSdkVersion() {
            if (this.mMinSdkVersion == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                ApiVersion minSdk = flavor.getMinSdkVersion();
                this.mMinSdkVersion = minSdk != null ? LintUtils.convertVersion((ApiVersion)minSdk, (IAndroidTarget[])this.mClient.getTargets()) : super.getMinSdkVersion();
            }
            return this.mMinSdkVersion;
        }

        @NonNull
        public AndroidVersion getTargetSdkVersion() {
            if (this.mTargetSdkVersion == null) {
                ProductFlavor flavor = this.mProject.getDefaultConfig().getProductFlavor();
                ApiVersion targetSdk = flavor.getTargetSdkVersion();
                this.mTargetSdkVersion = targetSdk != null ? LintUtils.convertVersion((ApiVersion)targetSdk, (IAndroidTarget[])this.mClient.getTargets()) : super.getTargetSdkVersion();
            }
            return this.mTargetSdkVersion;
        }

        public int getBuildSdk() {
            String compileTarget = this.mProject.getCompileTarget();
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            if (version != null) {
                return version.getApiLevel();
            }
            return super.getBuildSdk();
        }

        @Nullable
        public Boolean dependsOn(@NonNull String artifact) {
            if ("com.android.support:support-v4".equals(artifact)) {
                if (this.mSupportLib == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                    this.mSupportLib = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.mSupportLib;
            }
            if ("com.android.support:appcompat-v7".equals(artifact)) {
                if (this.mAppCompat == null) {
                    Dependencies dependencies = this.mVariant.getMainArtifact().getDependencies();
                    this.mAppCompat = AppGradleProject.dependsOn(dependencies, artifact);
                }
                return this.mAppCompat;
            }
            return super.dependsOn(artifact);
        }
    }
}

