/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.internal.model.ApiVersionImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ClassField;
import com.android.builder.model.NdkConfig;
import com.android.builder.model.ProductFlavor;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProductFlavorImpl
implements ProductFlavor,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private ApiVersion mMinSdkVersion = null;
    private ApiVersion mTargetSdkVersion = null;
    private int mRenderscriptTargetApi = -1;
    private boolean mRenderscriptSupportMode = false;
    private boolean mRenderscriptNdkMode = false;
    private int mVersionCode = -1;
    private String mVersionName = null;
    private String mApplicationId = null;
    private String mTestApplicationId = null;
    private String mTestInstrumentationRunner = null;
    private Boolean mTestHandleProfiling = null;
    private Boolean mTestFunctionalTest = null;
    private Set<String> mResourceConfigurations = null;
    private Map<String, String> mManifestPlaceholders = null;

    @NonNull
    static ProductFlavorImpl cloneFlavor(@NonNull ProductFlavor productFlavor, @Nullable ApiVersion minSdkVersionOverride, @Nullable ApiVersion targetSdkVersionOverride) {
        ProductFlavorImpl clonedFlavor = new ProductFlavorImpl();
        clonedFlavor.name = productFlavor.getName();
        clonedFlavor.mMinSdkVersion = minSdkVersionOverride != null ? minSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getMinSdkVersion());
        clonedFlavor.mTargetSdkVersion = targetSdkVersionOverride != null ? targetSdkVersionOverride : ApiVersionImpl.clone(productFlavor.getTargetSdkVersion());
        clonedFlavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        clonedFlavor.mRenderscriptSupportMode = productFlavor.getRenderscriptSupportMode();
        clonedFlavor.mRenderscriptNdkMode = productFlavor.getRenderscriptNdkMode();
        clonedFlavor.mVersionCode = productFlavor.getVersionCode();
        clonedFlavor.mVersionName = productFlavor.getVersionName();
        clonedFlavor.mApplicationId = productFlavor.getApplicationId();
        clonedFlavor.mTestApplicationId = productFlavor.getTestApplicationId();
        clonedFlavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        clonedFlavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        clonedFlavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        clonedFlavor.mResourceConfigurations = Sets.newHashSet((Iterable)productFlavor.getResourceConfigurations());
        clonedFlavor.mManifestPlaceholders = Maps.newHashMap((Map)productFlavor.getManifestPlaceholders());
        return clonedFlavor;
    }

    private ProductFlavorImpl() {
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getApplicationId() {
        return this.mApplicationId;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @Nullable
    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @Nullable
    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public int getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public boolean getRenderscriptSupportMode() {
        return this.mRenderscriptSupportMode;
    }

    public boolean getRenderscriptNdkMode() {
        return this.mRenderscriptNdkMode;
    }

    @Nullable
    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    @NonNull
    public Map<String, ClassField> getBuildConfigFields() {
        return Collections.emptyMap();
    }

    @NonNull
    public Map<String, ClassField> getResValues() {
        return Collections.emptyMap();
    }

    @NonNull
    public List<File> getProguardFiles() {
        return Collections.emptyList();
    }

    @NonNull
    public List<File> getConsumerProguardFiles() {
        return Collections.emptyList();
    }

    @Nullable
    public NdkConfig getNdkConfig() {
        return null;
    }

    @NonNull
    public Collection<String> getResourceConfigurations() {
        return this.mResourceConfigurations;
    }

    @NonNull
    public Map<String, String> getManifestPlaceholders() {
        return this.mManifestPlaceholders;
    }

    public String toString() {
        return "ProductFlavorImpl{name='" + this.name + '\'' + ", mMinSdkVersion=" + this.mMinSdkVersion + ", mTargetSdkVersion=" + this.mTargetSdkVersion + ", mRenderscriptTargetApi=" + this.mRenderscriptTargetApi + ", mRenderscriptSupportMode=" + this.mRenderscriptSupportMode + ", mRenderscriptNdkMode=" + this.mRenderscriptNdkMode + ", mVersionCode=" + this.mVersionCode + ", mVersionName='" + this.mVersionName + '\'' + ", mApplicationId='" + this.mApplicationId + '\'' + ", mTestApplicationId='" + this.mTestApplicationId + '\'' + ", mTestInstrumentationRunner='" + this.mTestInstrumentationRunner + '\'' + ", mTestHandleProfiling='" + this.mTestHandleProfiling + '\'' + ", mTestFunctionalTest='" + this.mTestFunctionalTest + '\'' + ", mResourceConfigurations='" + this.mResourceConfigurations + '\'' + ", mManifestPlaceholders='" + this.mManifestPlaceholders + '\'' + '}';
    }
}

