/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantConfiguration;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

public class ApplicationVariantFactory
implements VariantFactory {
    public static final String CONFIG_WEAR_APP = "wearApp";
    @NonNull
    private final BasePlugin basePlugin;

    public ApplicationVariantFactory(@NonNull BasePlugin basePlugin) {
        this.basePlugin = basePlugin;
    }

    @Override
    @NonNull
    public BaseVariantData createVariantData(@NonNull VariantConfiguration variantConfiguration) {
        return new ApplicationVariantData(variantConfiguration);
    }

    @Override
    @NonNull
    public BaseVariant createVariantApi(@NonNull BaseVariantData variantData) {
        return (BaseVariant)this.basePlugin.getInstantiator().newInstance(ApplicationVariantImpl.class, new Object[]{variantData, this.basePlugin});
    }

    @Override
    @NonNull
    public VariantConfiguration.Type getVariantConfigurationType() {
        return VariantConfiguration.Type.DEFAULT;
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public void createTasks(@NonNull BaseVariantData variantData, @Nullable Task assembleTask) {
        assert (variantData instanceof ApplicationVariantData);
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantData;
        this.basePlugin.createAnchorTasks(variantData);
        this.basePlugin.createCheckManifestTask(variantData);
        this.handleMicroApp(variantData);
        this.basePlugin.createMergeManifestsTask(variantData, "manifests");
        this.basePlugin.createGenerateResValuesTask(variantData);
        this.basePlugin.createRenderscriptTask(variantData);
        this.basePlugin.createMergeResourcesTask(variantData, true);
        this.basePlugin.createMergeAssetsTask(variantData, null, true);
        this.basePlugin.createBuildConfigTask(variantData);
        this.basePlugin.createProcessResTask(variantData, true);
        this.basePlugin.createProcessJavaResTask(variantData);
        this.basePlugin.createAidlTask(variantData, null);
        this.basePlugin.createCompileTask(variantData, null);
        this.basePlugin.createNdkTasks(variantData);
        this.basePlugin.addPackageTasks(appVariantData, assembleTask, true);
    }

    private void handleMicroApp(@NonNull BaseVariantData variantData) {
        Configuration config = (Configuration)this.basePlugin.getProject().getConfigurations().findByName(CONFIG_WEAR_APP);
        Set file = config.getFiles();
        int count = file.size();
        if (count == 1) {
            if (variantData.getVariantConfiguration().getBuildType().isEmbedMicroApp()) {
                this.basePlugin.createCopyMicroApkTask(variantData, config);
                this.basePlugin.createGenerateMicroApkDataTask(variantData, config);
            }
        } else if (count > 1) {
            throw new RuntimeException("wearApp configuration resolves to more than one apk.");
        }
    }
}

