/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.internal.LintGradleClient;
import com.android.build.gradle.internal.LintGradleProject;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.Pair;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class LintGradleRequest
extends LintRequest {
    @NonNull
    private final LintGradleClient mLintClient;
    @NonNull
    private final BasePlugin mPlugin;
    @Nullable
    private final String mVariantName;
    @NonNull
    private final AndroidProject mModelProject;

    public LintGradleRequest(@NonNull LintGradleClient client, @NonNull AndroidProject modelProject, @NonNull BasePlugin plugin, @Nullable String variantName, @NonNull List<File> files) {
        super((LintClient)client, files);
        this.mLintClient = client;
        this.mModelProject = modelProject;
        this.mPlugin = plugin;
        this.mVariantName = variantName;
    }

    @Nullable
    public Collection<Project> getProjects() {
        if (this.mProjects == null) {
            Variant variant = LintGradleRequest.findVariant(this.mModelProject, this.mVariantName);
            if (variant == null) {
                this.mProjects = Collections.emptyList();
                return this.mProjects;
            }
            Pair<LintGradleProject, List<File>> result = LintGradleProject.create(this.mLintClient, this.mModelProject, variant, this.mPlugin.getProject());
            this.mProjects = Collections.singletonList(result.getFirst());
            this.mLintClient.setCustomRules((List)result.getSecond());
        }
        return this.mProjects;
    }

    private static Variant findVariant(@NonNull AndroidProject project, @Nullable String variantName) {
        if (variantName != null) {
            for (Variant variant : project.getVariants()) {
                if (!variantName.equals(variant.getName())) continue;
                return variant;
            }
        }
        if (!project.getVariants().isEmpty()) {
            return (Variant)project.getVariants().iterator().next();
        }
        return null;
    }
}

