/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.dsl.AbiSplitData;
import com.android.build.gradle.internal.dsl.DensitySplitData;
import com.android.resources.Density;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;

public class Splits {
    private final DensitySplitData density;
    private final AbiSplitData abi;
    private static final Set<String> ABI_LIST = ImmutableSet.of((Object)"armeabi", (Object)"armeabi-v7a", (Object)"arm64-v8a", (Object)"x86", (Object)"x86_64", (Object)"mips", (Object[])new String[]{"mips64"});

    public Splits(@NonNull Instantiator instantiator) {
        this.density = (DensitySplitData)instantiator.newInstance(DensitySplitData.class, new Object[0]);
        this.abi = (AbiSplitData)instantiator.newInstance(AbiSplitData.class, new Object[0]);
    }

    public DensitySplitData getDensity() {
        return this.density;
    }

    public void density(Action<DensitySplitData> action) {
        action.execute((Object)this.density);
    }

    public AbiSplitData getAbi() {
        return this.abi;
    }

    public void abi(Action<AbiSplitData> action) {
        action.execute((Object)this.abi);
    }

    @NonNull
    public Set<String> getDensityFilters() {
        Density[] values = Density.values();
        HashSet fullList = Sets.newHashSetWithExpectedSize((int)(values.length - 1));
        for (Density value : values) {
            if (value == Density.NODPI) continue;
            fullList.add(value.getResourceValue());
        }
        return this.density.getApplicableFilters(fullList);
    }

    @NonNull
    public Set<String> getAbiFilters() {
        return this.abi.getApplicableFilters(ABI_LIST);
    }
}

