/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.internal.api.ApkVariantImpl;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.VariantConfiguration;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

public class ApplicationVariantFactory
implements VariantFactory<ApplicationVariantData> {
    public static final String CONFIG_WEAR_APP = "wearApp";
    @NonNull
    private final BasePlugin basePlugin;

    public ApplicationVariantFactory(@NonNull BasePlugin basePlugin) {
        this.basePlugin = basePlugin;
    }

    @Override
    @NonNull
    public ApplicationVariantData createVariantData(@NonNull VariantConfiguration variantConfiguration, @NonNull Set<String> densities, @NonNull Set<String> abis, @NonNull Set<String> compatibleScreens) {
        ApplicationVariantData variant = new ApplicationVariantData(this.basePlugin, variantConfiguration);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(compatibleScreens);
        }
        for (String density : densities) {
            for (String abi : abis) {
                variant.createOutput(density, abi);
            }
        }
        return variant;
    }

    @Override
    @NonNull
    public BaseVariant createVariantApi(@NonNull BaseVariantData<? extends BaseVariantOutputData> variantData) {
        ApplicationVariantImpl variant = (ApplicationVariantImpl)this.basePlugin.getInstantiator().newInstance(ApplicationVariantImpl.class, new Object[]{variantData, this.basePlugin});
        ApplicationVariantFactory.createApkOutputApiObjects(this.basePlugin, variantData, variant);
        return variant;
    }

    public static void createApkOutputApiObjects(@NonNull BasePlugin basePlugin, @NonNull BaseVariantData<? extends BaseVariantOutputData> variantData, @NonNull ApkVariantImpl variant) {
        List<? extends BaseVariantOutputData> outputList = variantData.getOutputs();
        ArrayList apiOutputList = Lists.newArrayListWithCapacity((int)outputList.size());
        for (BaseVariantOutputData baseVariantOutputData : outputList) {
            ApkVariantOutputData apkOutput = (ApkVariantOutputData)baseVariantOutputData;
            ApkVariantOutputImpl output = (ApkVariantOutputImpl)basePlugin.getInstantiator().newInstance(ApkVariantOutputImpl.class, new Object[]{apkOutput});
            apiOutputList.add(output);
        }
        variant.addOutputs((List)apiOutputList);
    }

    @Override
    @NonNull
    public VariantConfiguration.Type getVariantConfigurationType() {
        return VariantConfiguration.Type.DEFAULT;
    }

    @Override
    public boolean isLibrary() {
        return false;
    }

    @Override
    public void createTasks(@NonNull BaseVariantData<?> variantData, @Nullable Task assembleTask) {
        assert (variantData instanceof ApplicationVariantData);
        ApplicationVariantData appVariantData = (ApplicationVariantData)variantData;
        this.basePlugin.createAnchorTasks(variantData);
        this.basePlugin.createCheckManifestTask(variantData);
        this.handleMicroApp(variantData);
        this.basePlugin.createMergeAppManifestsTask(variantData);
        this.basePlugin.createGenerateResValuesTask(variantData);
        this.basePlugin.createRenderscriptTask(variantData);
        this.basePlugin.createMergeResourcesTask(variantData, true);
        this.basePlugin.createMergeAssetsTask(variantData, null, true);
        this.basePlugin.createBuildConfigTask(variantData);
        this.basePlugin.createProcessResTask(variantData, true);
        this.basePlugin.createProcessJavaResTask(variantData);
        this.basePlugin.createAidlTask(variantData, null);
        this.basePlugin.createCompileTask(variantData, null);
        if (!this.basePlugin.getExtension().getUseNewNativePlugin()) {
            this.basePlugin.createNdkTasks(variantData);
        }
        this.basePlugin.addPackageTasks(appVariantData, assembleTask, true);
    }

    private void handleMicroApp(@NonNull BaseVariantData<?> variantData) {
        Configuration config = (Configuration)this.basePlugin.getProject().getConfigurations().findByName(CONFIG_WEAR_APP);
        Set file = config.getFiles();
        int count = file.size();
        if (count == 1) {
            if (variantData.getVariantConfiguration().getBuildType().isEmbedMicroApp()) {
                this.basePlugin.createGenerateMicroApkDataTask(variantData, config);
            }
        } else if (count > 1) {
            throw new RuntimeException("wearApp configuration resolves to more than one apk.");
        }
    }
}

