/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.internal.api.ApkVariantOutputImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.variant.ApkVariantData;
import com.android.build.gradle.tasks.Dex;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.build.gradle.tasks.ZipAlign;
import com.android.builder.model.SigningConfig;
import java.io.File;
import java.util.Collection;
import org.gradle.api.DefaultTask;

public abstract class ApkVariantImpl
extends BaseVariantImpl
implements ApkVariant {
    protected ApkVariantImpl(@NonNull BasePlugin plugin) {
        super(plugin);
    }

    @NonNull
    protected abstract ApkVariantData getApkVariantData();

    @Override
    @Nullable
    public String getVersionName() {
        return this.getApkVariantData().getVariantConfiguration().getVersionName();
    }

    @Override
    public int getVersionCode() {
        return this.getApkVariantData().getVariantConfiguration().getVersionCode();
    }

    @Override
    public Dex getDex() {
        return this.getApkVariantData().dexTask;
    }

    @Override
    public DefaultTask getUninstall() {
        return this.getApkVariantData().uninstallTask;
    }

    @Override
    public SigningConfig getSigningConfig() {
        return this.getApkVariantData().getVariantConfiguration().getSigningConfig();
    }

    @Override
    public boolean isSigningReady() {
        return this.getApkVariantData().isSigned();
    }

    @Override
    @NonNull
    public Collection<File> getCompileLibraries() {
        return this.plugin.getAndroidBuilder().getCompileClasspath(this.getVariantData().getVariantConfiguration());
    }

    @Override
    @NonNull
    public Collection<File> getApkLibraries() {
        return this.plugin.getAndroidBuilder().getPackagedJars(this.getVariantData().getVariantConfiguration());
    }

    @Override
    public DefaultTask getInstall() {
        return this.getApkVariantData().installTask;
    }

    @Override
    @Deprecated
    public PackageApplication getPackageApplication() {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call getPackageApplication() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.getPackageApplication() is deprecated. Call it on one of variant.getOutputs() instead.");
        return ((ApkVariantOutputImpl)this.outputs.get(0)).getPackageApplication();
    }

    @Override
    @Deprecated
    public ZipAlign getZipAlign() {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call getZipAlign() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.getZipAlign() is deprecated. Call it on one of variant.getOutputs() instead.");
        return ((ApkVariantOutputImpl)this.outputs.get(0)).getZipAlign();
    }

    @Override
    @NonNull
    public ZipAlign createZipAlignTask(@NonNull String taskName, @NonNull File inputFile, @NonNull File outputFile) {
        if (this.outputs.size() > 1) {
            throw new RuntimeException(String.format("More than one output on variant '%s', cannot call createZipAlignTask() on it. Call it on one of its outputs instead.", this.getName()));
        }
        this.plugin.displayDeprecationWarning("variant.createZipAlignTask() is deprecated. Call it on one of variant.getOutputs() instead.");
        return ((ApkVariantOutputImpl)this.outputs.get(0)).createZipAlignTask(taskName, inputFile, outputFile);
    }
}

