/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.CodePanelRenderer;
import com.android.build.gradle.internal.test.report.ErroringAction;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.SimpleHtmlWriter;
import com.android.build.gradle.internal.test.report.TestResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.tasks.testing.TestResult;

class ClassPageRenderer
extends PageRenderer<ClassTestResults> {
    private final CodePanelRenderer codePanelRenderer = new CodePanelRenderer();

    ClassPageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected String getTitle() {
        return ((ClassTestResults)this.getModel()).getTitle();
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("div").attribute("class", "breadcrumbs").startElement("a").attribute("href", "index.html").characters("all").endElement().characters(" > ").startElement("a").attribute("href", String.format("%s.html", ((ClassTestResults)this.getResults()).getPackageResults().getFilename(this.reportType))).characters(((ClassTestResults)this.getResults()).getPackageResults().getName()).endElement().characters(String.format(" > %s", ((ClassTestResults)this.getResults()).getSimpleName())).endElement();
    }

    private void renderTests(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table").startElement("thead").startElement("tr").startElement("th").characters("Test").endElement();
        Map<String, Map<String, TestResult>> results = ((ClassTestResults)this.getResults()).getTestResultsMap();
        ArrayList devices = Lists.newArrayList(results.keySet());
        Collections.sort(devices);
        for (String device : devices) {
            htmlWriter.startElement("th").characters(device).endElement();
        }
        htmlWriter.endElement().endElement();
        HashSet tests = Sets.newHashSet();
        for (Map<String, TestResult> deviceMap : results.values()) {
            tests.addAll(deviceMap.keySet());
        }
        ArrayList sortedTests = Lists.newArrayList((Iterable)tests);
        Collections.sort(sortedTests);
        for (String testName : sortedTests) {
            htmlWriter.startElement("tr").startElement("td").characters(testName).endElement();
            TestResult.ResultType currentType = TestResult.ResultType.SKIPPED;
            for (String device : devices) {
                Map<String, TestResult> deviceMap = results.get(device);
                TestResult test = deviceMap.get(testName);
                htmlWriter.startElement("td").attribute("class", test.getStatusClass()).characters(String.format("%s (%s)", test.getFormattedResultType(), test.getFormattedDuration())).endElement();
                currentType = ClassPageRenderer.combineResultType(currentType, test.getResultType());
            }
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
    }

    public static TestResult.ResultType combineResultType(TestResult.ResultType currentType, TestResult.ResultType newType) {
        switch (currentType) {
            case SUCCESS: {
                if (newType == TestResult.ResultType.FAILURE) {
                    return newType;
                }
                return currentType;
            }
            case FAILURE: {
                return currentType;
            }
            case SKIPPED: {
                if (newType != TestResult.ResultType.SKIPPED) {
                    return newType;
                }
                return currentType;
            }
        }
        throw new IllegalStateException();
    }

    public String getStatusClass(TestResult.ResultType resultType) {
        switch (resultType) {
            case SUCCESS: {
                return "success";
            }
            case FAILURE: {
                return "failures";
            }
            case SKIPPED: {
                return "skipped";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void renderFailures(SimpleHtmlWriter htmlWriter) throws IOException {
        Map<String, Map<String, TestResult>> results = ((ClassTestResults)this.getResults()).getTestResultsMap();
        HashMap testPassPercent = Maps.newHashMap();
        for (TestResult test : ((ClassTestResults)this.getResults()).getFailures()) {
            String testName = test.getName();
            TestPercent percent = (TestPercent)testPassPercent.get(testName);
            if (percent != null && percent.isFullFailure()) continue;
            if (percent == null) {
                int failed = 0;
                int total = 0;
                for (Map<String, TestResult> deviceMap : results.values()) {
                    TestResult.ResultType resultType = deviceMap.get(testName).getResultType();
                    if (resultType == TestResult.ResultType.FAILURE) {
                        ++failed;
                    }
                    if (resultType == TestResult.ResultType.SKIPPED) continue;
                    ++total;
                }
                percent = new TestPercent(failed, total);
                testPassPercent.put(testName, percent);
            }
            String name = percent.total == 1 ? testName : (percent.isFullFailure() ? testName + " [all devices]" : String.format("%s [%s] (on %d/%d devices)", testName, test.getDevice(), percent.failed, percent.total));
            htmlWriter.startElement("div").attribute("class", "test").startElement("a").attribute("name", test.getId().toString()).characters("").endElement().startElement("h3").attribute("class", test.getStatusClass()).characters(name).endElement();
            for (TestResult.TestFailure failure : test.getFailures()) {
                this.codePanelRenderer.render(failure.getStackTrace(), htmlWriter);
            }
            htmlWriter.endElement();
        }
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addTab("Tests", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter writer) throws IOException {
                ClassPageRenderer.this.renderTests(writer);
            }
        });
        this.addDeviceAndVariantTabs();
    }

    private static final class TestPercent {
        int failed;
        int total;

        TestPercent(int failed, int total) {
            this.failed = failed;
            this.total = total;
        }

        boolean isFullFailure() {
            return this.failed == this.total;
        }
    }
}

