/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.annotations.NonNull;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class TypedefCollector
extends ASTVisitor {
    private Map<String, Annotation> mMap = Maps.newHashMap();
    private boolean mRequireHide;
    private boolean mRequireSourceRetention;
    private CompilationUnitDeclaration mCurrentUnit;
    private List<File> mClassFiles = Lists.newArrayList();

    public TypedefCollector(@NonNull Collection<CompilationUnitDeclaration> units, boolean requireHide, boolean requireSourceRetention) {
        this.mRequireHide = requireHide;
        this.mRequireSourceRetention = requireSourceRetention;
        Iterator<CompilationUnitDeclaration> i$ = units.iterator();
        while (i$.hasNext()) {
            CompilationUnitDeclaration unit;
            this.mCurrentUnit = unit = i$.next();
            unit.traverse((ASTVisitor)this, unit.scope);
            this.mCurrentUnit = null;
        }
    }

    public List<File> getNonPublicTypedefClassFiles() {
        return this.mClassFiles;
    }

    public Map<String, Annotation> getTypedefs() {
        return this.mMap;
    }

    public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
        return this.recordTypedefs(memberTypeDeclaration);
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        return this.recordTypedefs(typeDeclaration);
    }

    private boolean recordTypedefs(TypeDeclaration declaration) {
        SourceTypeBinding binding = declaration.binding;
        if (binding == null) {
            return false;
        }
        Annotation[] annotations = declaration.annotations;
        if (annotations != null && declaration.binding.isAnnotationType()) {
            for (Annotation annotation : annotations) {
                Javadoc javadoc;
                String typeName = Extractor.getFqn(annotation);
                if (typeName == null || !typeName.equals("android.support.annotation.IntDef") && !typeName.equals("android.support.annotation.StringDef") && !typeName.equals("android.annotation.IntDef") && !typeName.equals("android.annotation.StringDef")) continue;
                String fqn = new String(binding.readableName());
                this.mMap.put(fqn, annotation);
                if (this.mRequireHide && (javadoc = declaration.javadoc) != null) {
                    StringBuffer stringBuffer = new StringBuffer(200);
                    javadoc.print(0, stringBuffer);
                    String documentation = stringBuffer.toString();
                    if (!documentation.contains("@hide")) {
                        Extractor.display(this.getFileName() + ": The typedef annotation " + fqn + " should specify @hide in a doc comment");
                    }
                }
                if (this.mRequireSourceRetention && !Extractor.hasSourceRetention(annotations)) {
                    Extractor.display(this.getFileName() + ": The typedef annotation " + fqn + " must have @Retention(RetentionPolicy.SOURCE)");
                }
                if (declaration.binding == null || (declaration.modifiers & 1) != 0) continue;
                StringBuilder sb = new StringBuilder(100);
                for (char c : declaration.binding.qualifiedPackageName()) {
                    if (c == '.') {
                        sb.append(File.separatorChar);
                        continue;
                    }
                    sb.append(c);
                }
                sb.append(File.separatorChar);
                for (char c : declaration.binding.qualifiedSourceName()) {
                    if (c == '.') {
                        sb.append('$');
                        continue;
                    }
                    sb.append(c);
                }
                sb.append(".class");
                File file = new File(sb.toString());
                this.mClassFiles.add(file);
            }
        }
        return true;
    }

    private String getFileName() {
        return new String(this.mCurrentUnit.getFileName());
    }
}

