/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.ndk.NdkPlugin;
import com.android.builder.core.VariantConfiguration;
import java.io.File;
import java.util.Collection;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.runtime.base.Binary;

public class NdkLibrarySpecification {
    private Project currentProject;
    private String targetProjectName;

    private NdkPlugin getNdkPlugin() {
        Project targetProject = this.targetProjectName.isEmpty() ? this.currentProject : this.currentProject.getRootProject().project(this.targetProjectName);
        NdkPlugin plugin = (NdkPlugin)targetProject.getPlugins().findPlugin(NdkPlugin.class);
        if (plugin == null) {
            throw new InvalidUserDataException("Unable to find NdkPlugin in project '" + this.targetProjectName + "'.  You may " + "need define your compile dependencies such that " + targetProject + " is " + "configured before " + this.currentProject + ".");
        }
        return plugin;
    }

    public NdkLibrarySpecification(Project currentProject, String targetProjectName) {
        this.currentProject = currentProject;
        this.targetProjectName = targetProjectName;
    }

    public Collection<? extends Binary> getBinaries(VariantConfiguration variantConfig) {
        return this.getNdkPlugin().getBinaries(variantConfig);
    }

    public Collection<File> getOutputDirectories(VariantConfiguration variantConfig) {
        return this.getNdkPlugin().getOutputDirectories(variantConfig);
    }
}

